<?php
// اجرای آپدیت کرون جاب
if (isset($_GET['wra_cron_job']) && $_GET['wra_cron_job'] == 1) {
	add_action('init', 'wra_update_corn');
}

function wra_update_corn()
{
	$wra_state = get_option('wra_state');
	if ($wra_state == 'on') {
		$result = wra_cron_job();
		$insertTime = date('Y-m-d H:i:s', current_time('timestamp'));
		$address = '';
		if($result)
			wra_add_report('CronJob', $insertTime, $address, '', str_replace('<br>','\n',$result), 0, 0, "همگام سازی انجام نشد.");
		else
			wra_add_report('CronJob', $insertTime, $address, '', "همگام سازی با موفقیت انجام شد.", 200, 0, "همگام سازی با موفقیت انجام شد.");
	}




	// پاکسازی گزارشات
	if(get_option('wra_clear_db_state')=='on' && get_option('wra_clear_db_days'))
	{
		global $wpdb;
		$sql = "DELETE FROM `{$wpdb->base_prefix}wra_reports` WHERE insertTime<'".date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s').' -'.get_option('wra_clear_db_days').' day'))."'";
		$wpdb->query($sql);
	
		$sql = "DELETE FROM `{$wpdb->base_prefix}wra_queue` WHERE status != 0 and  created_at<'".date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s').' -'.get_option('wra_clear_db_days').' day'))."'";
		$wpdb->query($sql);
	}

	die;
}


// اجرای بروزرسانی در صفحه تنظیمات
if (isset($_GET['wra_update']) && $_GET['wra_update'] == 1 && !isset($_GET['settings-updated'])) {
	add_action('init', 'wra_update_manual');
}

function wra_update_manual()
{
	date_default_timezone_set('Asia/Tehran');
	$result = wra_cron_job();
	$insertTime = date('Y-m-d H:i:s', current_time('timestamp'));
	$address = '';
	if (!$result)
	{
		wra_add_report('manualUpdate', $insertTime, $address, '', "همگام سازی با موفقیت انجام شد.", 200, 0, "همگام سازی با موفقیت انجام شد.");
		wra_notice("همگام سازی با موفقیت انجام شد.", 'success');
	}
	else
	{
		wra_add_report('manualUpdate', $insertTime, $address, '', str_replace('<br>','\n',$result), 0, 0, "همگام سازی انجام نشد.");
		wra_notice("همگام سازی انجام نشد.<br>".$result, 'error');
	}
		
}





// کرون جاب دریافت قیمت طلا
if (isset($_GET['wra_gold_cron_job']) && $_GET['wra_gold_cron_job'] == 1) {

	$check_time = (time() - get_option('wra_gold_price_time')) / 60;

	if(get_option('wra_cron_job_status') == 'on' && ($check_time >= get_option('wra_cron_job_time') || !get_option('wra_cron_job_time')) )
	{
		
		add_action('init', 'wra_get_cron_price');
			
	}

}

function wra_get_cron_price()
{
	$date = new jalaliDate();
	$wra_gold_price = 0;



	if(get_option('wra_gold_web_service')=='zarbaha')
	{
		$zarbahaApi = new zarbahaApi; 
		$wra_gold_price = $zarbahaApi -> get_price();
	}	
	elseif(get_option('wra_gold_web_service')=='taban')
	{
		$tabanApi = new tabanApi; 
		$wra_gold_price = $tabanApi -> get_price();
	}
	elseif(get_option('wra_gold_web_service')=='ratebox')
	{
		$rateBox = new rateBox; 
		$wra_gold_price = $rateBox -> get_price();
	}


	if(intval($wra_gold_price)>0)
	{
		// update_option('wra_gold_price', intval($wra_gold_price));
		// update_option('wra_gold_price_time', time());
		// update_option('wra_gold_price_date', $date->getNumberInPersian(date('Y-m-d H:i')));
		// update_option('wra_gold_price_service', get_option('wra_gold_web_service'));

		update_option('wra_gold_price', intval($wra_gold_price)); 
		update_option('wra_gold_price_time', time());
		update_option('wra_gold_price_date', $date->getDate(date('Y-m-d')).date(' - H:i:s'));
		update_option('wra_gold_price_service', get_option('wra_gold_web_service'));


	}

	wra_update_products_with_gold_price();

	die;
	
}





//   دکمه دریافت قیمت طلا در تنظیمات
if (isset($_GET['wra_gold_price']) && $_GET['wra_gold_price'] == 1) {
	add_action('init', 'wra_get_price');
}

function wra_get_price()
{


	date_default_timezone_set('Asia/Tehran');
	$date = new jalaliDate();
	$wra_gold_price = 0;

	if(get_option('wra_gold_web_service')=='zarbaha')
	{
		$zarbahaApi = new zarbahaApi; 
		$wra_gold_price = $zarbahaApi -> get_price();
	}	
	elseif(get_option('wra_gold_web_service')=='taban')
	{
		$tabanApi = new tabanApi; 
		$wra_gold_price = $tabanApi -> get_price();
	}
	elseif(get_option('wra_gold_web_service')=='ratebox')
	{
		$rateBox = new rateBox; 
		$wra_gold_price = $rateBox -> get_price();
	}


	if(intval($wra_gold_price)>0)
	{
		update_option('wra_gold_price', intval($wra_gold_price)); 
		update_option('wra_gold_price_time', time());
		update_option('wra_gold_price_date', $date->getDate(date('Y-m-d')).date(' - H:i:s'));
		update_option('wra_gold_price_service', get_option('wra_gold_web_service'));

		wra_update_products_with_gold_price();


		$wra_gold_web_service = '';
		switch(get_option('wra_gold_web_service'))
		{
			case 'zarbaha': $wra_gold_web_service = ' (زر بها)'; break;
			case 'taban': $wra_gold_web_service = ' (تابان گوهر نفیس)'; break;
			case 'ratebox': $wra_gold_web_service = ' (ریت باکس)'; break;		
		} 
		echo json_encode([
			'data'=> '<span >'.number_format(intval($wra_gold_price)).'</span> تومان <span><br>زمان آخرین دریافت:'.($date->getDate(date('Y-m-d')).date(' - H:i:s')).$wra_gold_web_service.'</span>'
		]);
	}
	die;

}








