<?php
$api_version = 1;
ini_set('serialize_precision', 14);
ini_set('precision', 14);

// Adding .svg extension
add_filter( 'upload_mimes', 'wra_myme_types', 1, 1 );
function wra_myme_types( $mime_types ) {
  $mime_types['svg'] = 'image/svg+xml';     
  return $mime_types;
}










function wra_connect($forced = 0)
{	
	if (wra_check_connection()!=1)
		return false;

	$wra_state = get_option('wra_state');
	if ($wra_state == 'on') {
		$ip = get_option('wra_ip');
		$port = get_option('wra_port');
		$API_KEY = get_option('wra_api_key');
		$api_connection = get_option('wra_connect');
		$token = get_option('wra_token');
		$wra_token_time = get_option('wra_token_time');
		$tokenId = get_option('wra_tokenId');
		
		$mac = get_option('wra_mac');

		$con = new pejvakApi($API_KEY, $ip, $port);

		if (!$api_connection || !$tokenId || $forced) {
			$getToket = $con->getToket();
			
			if(!$getToket) wra_disconnect();

			$tokenId = $getToket['tokenId'];
			$token = $getToket['token'];
			$wra_token_time = $getToket['wra_token_time'];
			$mac = $getToket['mac'];
			update_option('wra_tokenId', $tokenId);
			update_option('wra_token', $token);
			update_option('wra_token_time', $wra_token_time);
			update_option('wra_mac', $mac);			
			update_option('wra_connect', 1);
			update_option('wra_connect_msg', $getToket['resMsg']);
		}
		return $con;
	} 
	else
	{
	    return null;
	}
}

function wra_disconnect()
{
	update_option('wra_tokenId', 0);
	update_option('wra_token', '');
	update_option('wra_token_time', '');
	update_option('wra_mac', '');
	update_option('wra_connect', 0);
}

function wra_get_token()
{
	$token = get_option('wra_token');
	$wra_token_time = get_option('wra_token_time');
	if($token)
	{
		if($wra_token_time - 60 > time())
			return $token;
		else
		{
			wra_connect(1);
			if(get_option('wra_token'))
				return get_option('wra_token');
		}
	}
	return '';
}


//Api Functions/////////////////////////////////////////////////////////////////////////////////////////////////////////
function wra_check_connection()
{
	$ip = get_option('wra_ip');
	$port = get_option('wra_port');
	$API_KEY = get_option('wra_api_key');
	$con = new pejvakApi($API_KEY, $ip, $port);
	$url = get_option('wra_ip');
	if ($port)
		$url .= ':' . $port;

	$result = $con->wra_check_connection($url);
	update_option('wra_connect', $result['state']);

	$insertTime = date('Y-m-d H:i:s', current_time('timestamp'));
	$address = $url.'/WebApiService/api/v1/TimeStamp/ConnectToDatabase';
	global $wra_http_status;
	wra_add_report('GetTimeStamp', $insertTime, $address, '', json_encode($result['data']),$wra_http_status);

	return $result['state'];
}

function wra_get_product_groups()
{
	$token = wra_get_token();
	$tokenId = get_option('wra_tokenId');
	$mac = get_option('wra_mac');

	$con = wra_connect();
    	if ($con && $tokenId) {
    		$GetProductGroups = $con->GetProductGroups($mac, $tokenId);
	
    		if (!wra_check_token($GetProductGroups)) {
				$token = wra_get_token();
    			$tokenId = get_option('wra_tokenId');
    			$mac = get_option('wra_mac');
    			$GetProductGroups = $con->GetProductGroups($mac, $tokenId);
    		}
    		return $GetProductGroups;
    	}

    return null;
}

function wra_get_products_simple()
{
	$token = wra_get_token();
	$tokenId = get_option('wra_tokenId');
	$mac = get_option('wra_mac');
	$con = wra_connect();
	if ($con && $tokenId) {
		$insertTime = date('Y-md H:i:s');
		$GetProductsSimpleDetail = $con->GetProductsSimpleDetail($mac, $tokenId);		
		if (!wra_check_token($GetProductsSimpleDetail)) {
			$token = wra_get_token();
			$tokenId = get_option('wra_tokenId');
			$mac = get_option('wra_mac');
			$GetProductsSimpleDetail = $con->GetProductsSimpleDetail($mac, $tokenId);
		}
		return $GetProductsSimpleDetail;
	}
	return null;
}
function wra_get_products()
{
	$token = wra_get_token();
	$tokenId = get_option('wra_tokenId'); 
	$mac = get_option('wra_mac');
	
	$con = wra_connect(); 

	if ($con && $tokenId) {
		$updates_count = get_option('wra_updates');
		$updates_page = get_option('wra_last_updates') ? get_option('wra_last_updates') : 1;
		$GetProducts = $con->GetProducts($mac, $tokenId, $updates_page, $updates_count);

		if (!wra_check_token($GetProducts)) {
			$token = wra_get_token();
			$tokenId = get_option('wra_tokenId');
			$mac = get_option('wra_mac');
			$GetProducts = $con->GetProducts($mac, $tokenId, $updates_page, $updates_count);
		}
 
		if (isset($GetProducts->paging) && ((($GetProducts->paging->totalItems) / $updates_count)) > $updates_page) {
			update_option('wra_last_updates', intval($updates_page) + 1);
		} else {
			update_option('wra_last_updates', 1);
		}

		return $GetProducts;
	}
		return null;
}

function wra_get_product($productId)
{
	global $wpdb;
	$query = "SELECT * FROM {$wpdb->base_prefix}wra_products_map where productId=" . $productId;

	$result = $wpdb->get_results($query);
	
	if (sizeof($result)) {

		$token = wra_get_token();
		$tokenId = get_option('wra_tokenId');

		$con = wra_connect();
		if ($con && $tokenId) {
			$mac = $con->encrypt_data(
				md5(
					json_encode(
						array(
							"tokenId" => intval($tokenId),
							"productId" => intval($result[0]->apiProductId)
						)
					)
				),
				$token
			);
			
			$GetProducts = $con->GetProduct($mac, $tokenId, $result[0]->apiProductId);
		
			if (!wra_check_token($GetProducts)) { 
				$token = wra_get_token();
				$tokenId = get_option('wra_tokenId');
				
				$mac = $con->encrypt_data(
					md5(
						json_encode(
							array(
								"tokenId" => intval($tokenId),
								"productId" => intval($result[0]->apiProductId)
							)
						)
					),
					$token
				);
				$GetProducts = $con->GetProduct($mac, $tokenId, $result[0]->apiProductId);
			}
			return $GetProducts;
		}
	}
	return null;
}


function wra_send_factor($order_id, $data)
{
	global $wpdb;
	$GetProducts = null;
	$token = wra_get_token();
	$tokenId = get_option('wra_tokenId');
	
	$con = wra_connect();
	$data['TokenId'] = intval($tokenId);


		$ip = get_option('wra_ip');
		$port = get_option('wra_port');
		$API_KEY = get_option('wra_api_key');
		$mac = get_option('wra_mac');
		$con1 = new pejvakApi($API_KEY, $ip, $port);
		if ($con1) {
			$FactorNew = json_encode($data, JSON_PARTIAL_OUTPUT_ON_ERROR);
			
			$mac = $con1->encrypt_data(md5($FactorNew), $token);
			$data['Mac'] = $mac;
			$FactorNew = json_encode($data, JSON_PARTIAL_OUTPUT_ON_ERROR);

			$queue_id = wra_add_queue('/WebApiService/api/v1/Factor/GoldFactorAdd', $FactorNew, 'POST');

			if ($con && $tokenId) {
				$GetProducts = $con->sendFactor($FactorNew,$queue_id);
				if (!wra_check_token($GetProducts)) {
					$token = wra_get_token();
					$tokenId = get_option('wra_tokenId');
					
					$data['TokenId'] = intval($tokenId);					
					unset($data['Mac']);
					$FactorNew = json_encode($data, JSON_PARTIAL_OUTPUT_ON_ERROR);
					$mac = $con->encrypt_data(md5($FactorNew), $token);
					$data['Mac'] = $mac;
					$FactorNew = json_encode($data, JSON_PARTIAL_OUTPUT_ON_ERROR);
					$GetProducts = $con->sendFactor($FactorNew,$queue_id);
				}

				global $wra_http_status;
				if ($GetProducts && $wra_http_status == 200 && $GetProducts->res>=0)
					wra_update_state_queue($queue_id, 1);
				return $GetProducts;
			}

		}
	
	return null;
}
////////////////queue///////////////////////
function wra_add_queue($url, $data = '', $method = 'POST')
{
	global $wpdb;
	wra_check_queue_table_exist();
	$table = "wra_queue";
	$table_name = $wpdb->base_prefix . $table;
	$created_at = date('Y-m-d H:i:s', current_time('timestamp'));

	$data=json_encode(json_decode($data),JSON_UNESCAPED_UNICODE);
	
	$sql = "INSERT INTO {$table_name} (url,data,method,status,created_at) 
			VALUES ('{$url}','{$data}','{$method}',0,'{$created_at}')";
	$wpdb->query($sql);
	$queue_id = $wpdb->insert_id;
	wra_add_queue_product($data, $queue_id);
	return $queue_id;
}

function wra_add_queue_product($data, $queue_id)
{
	global $wpdb;
	wra_check_queue_product_table_exist();
	$table = "wra_queue_products";
	$table_name = $wpdb->base_prefix . $table;
	$data=json_decode($data);
	if(!empty($data->FactorItems))
		foreach($data->FactorItems as $item)
		{

			$sql = "SELECT productId FROM {$wpdb->base_prefix}wra_products_map WHERE id={$item->ProductId}  LIMIT 1";
			$map = $wpdb->get_results($sql);
			
			if($map)
			{
				$sql = "INSERT INTO {$table_name} (queue_id,product_id,counts) 
						VALUES ('{$queue_id}','{$map[0]->productId}','{$item->Count}')";
				$wpdb->query($sql);	
			}		
		}
}

function wra_queue_products_count($productId)
{
	global $wpdb;
	wra_check_queue_product_table_exist();
	$sql = "SELECT sum(`{$wpdb->base_prefix}wra_queue_products`.counts) as counts 
				FROM `{$wpdb->base_prefix}wra_queue_products` 
				join `{$wpdb->base_prefix}wra_queue` on `{$wpdb->base_prefix}wra_queue`.id = `{$wpdb->base_prefix}wra_queue_products`.`queue_id` and `{$wpdb->base_prefix}wra_queue`.`status` = 0 
				WHERE `{$wpdb->base_prefix}wra_queue_products`.product_id='{$productId}';";

	$result = $wpdb->get_results($sql);
	if($result && $result[0]->counts)
		return $result[0]->counts;
	else 
		return 0;

}

function wra_get_product_count($productId)
{
	$product_quantity = -1;
	$api_product = wra_get_product($productId);
	if ($api_product && $api_product->res==0 )
	{
		$product_quantity = $api_product->product->productRefCurrentAmountCount - wra_queue_products_count($productId);	
		if($product_quantity<0)$product_quantity=0;
	}
	return $product_quantity;
}

function wra_get_queues($id=0)
{
	wra_check_queue_table_exist();
	global $wpdb;
	$table = "wra_queue";
	$table_name = $wpdb->base_prefix . $table;
	if($id) $where = ' and id='.$id;else $where = '';
	$query = "SELECT * FROM {$table_name} where status=0 {$where} order by id asc";
	return $wpdb->get_results($query);
}
function wra_update_state_queue($id, $status)
{
	wra_check_queue_table_exist();
	global $wpdb;
	$table = "wra_queue";
	$table_name = $wpdb->base_prefix . $table;
	$date = date('Y-m-d H:i:s', current_time('timestamp'));
	if($status)
		$sql = "UPDATE {$table_name} set status = {$status}, retry = retry + 1 , send_at = '{$date}' WHERE id = {$id}";
	else
	    $sql = "UPDATE {$table_name} set status = {$status}, retry = retry + 1 WHERE id = {$id}";
	return $wpdb->query($sql);
}
function wra_resend_queue($id)
{
	wra_send_queue($id);
}

function wra_delete_queue($id)
{
	global $wpdb;
	$table = "wra_queue";
	$table_name = $wpdb->base_prefix . $table;
	$sql = "UPDATE {$table_name} SET status = -2 WHERE status = 0 and data like '%\"FactorNumber\":\"{$id}\"%'";
	return $wpdb->query($sql);
}


function wra_get_queue_count()
{
	wra_check_queue_table_exist();
	global $wpdb;
	$table = "wra_queue";
	$table_name = $wpdb->base_prefix . $table;
	$query = "SELECT count(*) as counts FROM {$table_name} where status=0";
	$result = $wpdb->get_results($query);
	if ($result)
		return $result[0]->counts;
	else
		return 0;
}

function wra_send_queue($id=0)
{


		$msg='';
		$ip = get_option('wra_ip');
		$port = get_option('wra_port');
		$API_KEY = get_option('wra_api_key');
		$con = new pejvakApi($API_KEY, $ip, $port);
		$token = wra_get_token();
		$id = 0;


		if(!wra_connect())$msg = 'عدم ارتباط با وب سرویس<br>';

		$queues = wra_get_queues($id);
		$send_factor = get_option('wra_send_factor');
		if ($queues && $send_factor=='on')
			foreach ($queues as $item) {

				$data = json_decode($item->data);

				if(!isset($data->Factor))
				{
					global $wpdb;
					$table = "wra_queue";
					$table_name = $wpdb->base_prefix . $table;
					$sql = "DELETE FROM {$table_name} WHERE id=".$item->id;
					$wpdb->query($sql);
					continue;
				}

				// آپدیت کد کالا در فاکتور
				if(isset($data->FactorItems))
				{
					foreach($data->FactorItems as $key => &$FactorItem){
						global $wpdb;

						if($FactorItem->ProductId)
						{
							$query = "SELECT * FROM {$wpdb->base_prefix}wra_products_map where apiProductId=" . $FactorItem->ProductId;					
							$result = $wpdb->get_results($query);					
							if($result && $result[0]->ProductCnuId)$FactorItem->ProductCnuId = $result[0]->ProductCnuId;
						}
						else
						{
							if (function_exists('wc_get_order')) {		
								$order = wc_get_order(intval($data->Factor->FactorNumber));						   
								if($order)
								{
									$items = $order->get_items();
									if($items)
									{
										$keys = array_keys($items);										
										if($keys && isset($items[$keys[$key]]) && $order_row = $items[$keys[$key]])
										{			 		
											$query = "SELECT * FROM {$wpdb->base_prefix}wra_products_map where productId=" . $order_row['product_id'];					
											$result = $wpdb->get_results($query);
											if($result && $result[0]->apiProductId)
											{
												$FactorItem->ProductId = $result[0]->apiProductId;
												$FactorItem->ProductCnuId = $result[0]->ProductCnuId;
											
											}
										}
									}
								}
							}
							
						
						}


					}
				}
		

				// اصلاح تاریخ در صورت اشتباه بودن
				if(isset($data->Factor) && isset($data->Factor->RegisterFactorDate))
				{
					$jdate = new jalaliDate();	
					if(strtotime($data->Factor->RegisterFactorDate)<strtotime('2000/01/01')) 
						$data->Factor->RegisterFactorDate = $jdate->getDate(date('Y-m-d', strtotime($item->created_at)));
				}



				$token = wra_get_token();
				$tokenId = get_option('wra_tokenId');
				

				$data->TokenId = intval($tokenId);				
				unset($data->Mac);
				$FactorNew = json_encode($data);
				$mac = $con->encrypt_data(md5($FactorNew), $token);
				$data->Mac = $mac;
				$FactorNew = json_encode($data);
					

				$result_data = $con->get($item->url, $FactorNew, $item->method);
				$result = json_decode($result_data);
				global $wra_http_status;
				if ($result && $wra_http_status==200 && $result->res>=0) {
					wra_update_state_queue($item->id, 1);
				}
				else
				{
					if($msg && $result->resMsg)
						$msg.= $result->resMsg.'<br>';
					wra_update_state_queue($item->id, 0);
				}

				$url = get_option('wra_ip');
				$port = get_option('wra_port'); 
				if ($port && $port!=80)$url .= ':' . $port;
				$address = $url.'/WebApiService/api/v1/Factor/GoldFactorAdd'; 
				
				$insertTime = date('Y-m-d H:i:s', current_time('timestamp'));
			
				wra_add_report('FactorAdd', $insertTime, $address, json_encode($data), $result_data,$wra_http_status, $item->id);


			}
		return $msg;



}

///////////////////////////////////////////////////////////////////////////////////////////////////////////

function wra_update_product_groups()
{
	global $wpdb;
	wra_check_groups_table_exist();
	$groups = wra_get_product_groups();
	$insertTime = date('Y-m-d H:i:s', current_time('timestamp'));
	$groupIds = [];
	if ($groups && $groups->res==0) {
		if(!empty($groups->productGroups)){
			foreach ($groups->productGroups as $group) {
				$check_row = $wpdb->get_results("SELECT group_id FROM {$wpdb->base_prefix}wra_groups WHERE (group_id = {$group->id})");
				$groupIds [] = $group->id;
				if ($check_row && sizeof($check_row)) {
					$data = [
						'title' => $group->title,
						'groupParentID' => $group->groupParentID
					];
					wra_update_multiple_row($wpdb->base_prefix . 'wra_groups', $data, 'group_id=' . $group->id);
					
					if(get_option('wra_save_action_logs')=='on')
						wra_add_report('updateGroup', $insertTime, '', json_encode($group), "", 200, 0, "گروه بروزرسانی شد.");


				} else {
					$data = [
						[
							'group_id' => $group->id,
							'title' => $group->title,
							'groupParentID' => $group->groupParentID,
							'siteGroupId' => 0,
						]
					];
					wra_insert_multiple_rows($wpdb->base_prefix . 'wra_groups', $data);

					if(get_option('wra_save_action_logs')=='on') 
						wra_add_report('addGroup', $insertTime, '', json_encode($group), "", 200, 0, "گروه اضافه شد.");


				}

			}

			wra_delete_multiple_row($wpdb->base_prefix . 'wra_groups', ' group_id not in ('.implode(',',$groupIds).')');


		}
		return '';

	} else {
		return $groups->resMsg;
	}
}
function wra_update_products()
{
	global $wpdb;
	$products = wra_get_products();

	wra_update_product_meta();
	
	wra_check_products_map_table_exist();



	if($products && $products->res==0)
	{
		if(isset($products->paging->totalItems))
		{
			$product_total=$products->paging->totalItems;
			update_option('wra_total_products',$product_total);
			$product_from = ($products->paging->currentPage-1)*$products->paging->itemsPerPage+1;
			update_option('wra_from_product',$product_from);
			$product_to = ($products->paging->currentPage-1)*$products->paging->itemsPerPage+$products->paging->itemsPerPage;
			if(intval($product_to)>intval($product_total))$product_to=$product_total;
			update_option('wra_to_product',$product_to);
		}
		
		if (!empty($products->products)) {

			$error_list = [];
			foreach ($products->products as $product) {
				$sql = "SELECT productId FROM {$wpdb->base_prefix}wra_products_map WHERE productCode={$product->productCode}  LIMIT 1";
				$data = $wpdb->get_results($sql);				
				if(!$data)
				{
					// اگر کد کالا وجود داشت و از نرم افزار دریافت نشده بود خطا برگرداند
				    if(!empty($wpdb->postmeta) && $wpdb->get_var($wpdb->prepare("SELECT post_id FROM $wpdb->postmeta  join $wpdb->posts on  $wpdb->postmeta.post_id =  $wpdb->posts.id WHERE meta_key='_sku' AND meta_value='%s' LIMIT 1", $product->productCode)))
					{
						$error_list[] = $product->productCode;
					}
				}
			}//die;
			
			if(!empty($error_list)) return "کد کالای ".implode(', ',$error_list)." در سایت وجود دارد.";


			foreach ($products->products as $product) {


				// if($product->productImage && get_option('wra_update_images')=='on')
				// 	$image = wra_get_image($product->productImage);
				// else
				$image = 0;
				


				$product_data = array(
					'productId' => $product->productID,
					'productUnitID' => $product->productUnitID,
					'name' => $product->productName,
					'slug' => sanitize_title($product->productName),
					'status' => get_option('wra_active_products')=='on' ? 'publish' : 'pending',
					'description' => $product->productDescription,
					'sku' => $product->productCode,
					'price' => $product->productFinalPrice,
					'regular_price' => $product->productSalePrice,
					'sale_price' => $product->productFinalPrice,
					'manage_stock' => 1,
					'stock_quantity' => $product->productRefCurrentAmountCount,									
					'stock_status' => 'instock',
					'image_id' => $image,
					'productGroups' => $product->productGroups,

					'meta' => [ 
						'ProductType'	=> $product->productType,	
						'productTypeTitle'	=> $product->productTypeTitle,							
						'ProductBarcode'	=> $product->productBarcode,					
						'ProductGroupID'	=> $product->productGroupID,
						'ProductGroupName'	=> $product->productGroupName,
						'ProductGroupItemID'	=> $product->productGroupItemID,
						'ProductGroupItemName'	=> $product->productGroupItemName,
						'ProductCutie'			=> $product->productCutie,			
						'ProductUnit'	=> $product->productUnit,
						'ProductSaleFeeType'	=> $product->productSaleFeeType,
						'ProductSaleFeeTypeTitle'	=> $product->productSaleFeeTypeTitle,
						'ProductSaleFeeValue'	=> wra_site_price($product->productSaleFeeValue),
						'ProductSaleFeePercent'	=> $product->productSaleFeePercent,
						'ProductPriceCalculationType'	=> $product->productPriceCalculationType,
						'ProductPriceCalculationTypeTitle'	=> $product->productPriceCalculationTypeTitle,
						'ProductPrimaryWeight'	=> $product->productPrimaryWeight,
						'ProductRockRialCost'	=> wra_site_price($product->productRockRialCost),
						'ProductRockWeight'	=> $product->productRockWeight,
						'ProductRockCount'	=> $product->productRockCount,
						'ProductToll'	=> $product->productToll,
						'ProductTax'	=> $product->productTax,
						'ProductExemptOnSale'	=> $product->productExemptOnSale,
						'ProductIsDisabled'	=> $product->productIsDisabled,
						'ProductIsInteger'	=> $product->productIsInteger,
						'ProductSalePrice'		=> wra_site_price($product->productSalePrice),				
						// 'ProductComment'	=> $product->productComment,
						'ProductLeatherRialCost'	=> wra_site_price($product->productLeatherRialCost),
						'ProductSilverRialCost'	=> wra_site_price($product->productSilverRialCost),
						'ProductCalcTaxTollType'	=> $product->productCalcTaxTollType,
						'ProductRefCurrentAmount_Count'	=> $product->productRefCurrentAmountCount,
						'ProductRefCurrentAmount_Gold'	=> $product->productRefCurrentAmountGold,
						'ProductProfitKind'	=> $product->productProfitKind,
						'ProductProfitValue'	=> wra_site_price($product->productProfitValue),
						'_weight' => $product->productPrimaryWeight,
					]
				);

				$productObj = new Wra_Product_class();

				global $wpdb;	
				$productId = 0;
				$sql = "SELECT productId FROM {$wpdb->base_prefix}wra_products_map WHERE productCode={$product->productCode}  LIMIT 1";
				$data = $wpdb->get_results($sql);
				if($data)
				{
					$productId = $data[0]->productId;
					
					if($productId)
					{
						$sql = "SELECT ID FROM {$wpdb->base_prefix}posts WHERE ID={$productId} LIMIT 1";
						$data = $wpdb->get_results($sql);
						if(!$data){	
							$sql = "DELETE FROM {$wpdb->base_prefix}wra_products_map WHERE productId={$productId}";
							$wpdb->query($sql);		
							$productId = 0;			
						}
					}				
				}
				else
				{ 
				    if(!empty($wpdb->postmeta))$productId = $wpdb->get_var($wpdb->prepare("SELECT post_id FROM $wpdb->postmeta WHERE meta_key='_sku' AND meta_value='%s' LIMIT 1", $product->productCode));
					if($productId && !empty($wpdb->posts))$productId = $wpdb->get_var($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE ID='%s'  LIMIT 1", $productId));
				} 

				$insertTime = date('Y-m-d H:i:s', current_time('timestamp'));


				if ($productId)
				{
				  
					$productObj->update_product($productId, $product_data);

					if(!empty($product->productImage))
                    	$product->productImage = 'Array';   

					if(get_option('wra_save_action_logs')=='on')
						wra_add_report('updateProduct', $insertTime, '', json_encode($product), "", 200, 0, "محصول بروزرسانی شد.");
				}
				else
				{   


					$productObj->add_product($product_data);


					if(!empty($product->productImage))
						$product->productImage = 'Array';   

					if(get_option('wra_save_action_logs')=='on')
						wra_add_report('addProduct', $insertTime, '', json_encode($product), "", 200, 0, "محصول اضافه شد.");
				}
				

			}

		} 
		return '';
	}
	else{
		return $products->resMsg;
	}

}

function wra_update_product_meta()
{
	global $wpdb;
	$query = "SELECT p.ID
				FROM {$wpdb->base_prefix}posts as p 
				where p.post_type='product' and p.post_status = 'publish'";

	$produts = $wpdb->get_results($query);
	foreach($produts as $post_array)
	{
		if($post_array->ID && !get_post_meta($post_array->ID, 'product_api_type')[0])
		{	
			update_post_meta($post_array->ID, 'product_api_type', 0);
		}
	}
}

function wra_update_products_simple()
{

}

function wra_cron_job()
{

	//var_dump(wra_get_product(131));die;



	$wra_priceInWC = get_option('woocommerce_currency');
	if($wra_priceInWC!= 'IRR' && $wra_priceInWC!='IRT')
	{
		return 'واحد پولی ووکامرس باید ریال یا تومان باشد.
		<a class="button button-danger" href="?page=wc-settings">تغییر واحد پولی</a>';
	}
	else
	{

		update_option('wra_connect_msg', '');
		$result = '';
		$result.=wra_send_queue();
	
		if(!$result)
		{
			
			if(get_option('wra_update_groups')=='on' && $msg=wra_update_product_groups())
				$result.=$msg.'<br>';  
			if(!$result)
			{
				if($msg=wra_update_products())
					$result.=$msg.'<br>';  
					
					if(!$result)
					{
						$connection_msg = get_option('wra_connect_msg');
						if($connection_msg && $connection_msg!='بدون خطا')
							$result=$connection_msg.'<br>'.$result;
					}
			}
		}
		
		return $result; 
		

	}

	




}

function wra_check_token($data)
{

	if (isset($data->res) && $data->res != 0) {

		if ($data->res == -9 || $data->res == -10)
			{
				wra_connect(1);
				return false;
			}	
	} 
	return true;
}

function wra_add_report($action, $insertTime = '', $address = '', $json = '', $response = '', $wra_http_status=200, $queue_id=0, $description='')
{
	
	global $wpdb;
	$table = "wra_reports";
	$table_name = $wpdb->base_prefix . $table;
	wra_check_reports_table_exist();
	$updateTime = date('Y-m-d H:i:s', current_time('timestamp'));
	$json=str_replace('\'','',$json);
	$response=str_replace('\'','',$response);

	if($response)
	{
		$resp=json_decode($response);
		if(isset($resp->resMsg))$description=$resp->resMsg;
	}

	if($json)
		$json=json_encode(json_decode($json),JSON_UNESCAPED_UNICODE);
	
	$sql = "INSERT INTO {$table_name} (action,insertTime,updateTime,address,json,response,status,description,queue_id) 
			VALUES ('{$action}','{$insertTime}','{$updateTime}','{$address}','{$json}','{$response}','{$wra_http_status}','{$description}',{$queue_id})";

	$wpdb->query($sql);

}


//Database Functions/////////////////////////////////////////////////////////////////////////////////////////////////////////

function wra_check_tables()
{
	wra_check_groups_table_exist();
	wra_check_reports_table_exist();
	wra_check_queue_table_exist();
	wra_check_queue_product_table_exist();
	wra_check_products_map_table_exist();
}


function wra_check_groups_table_exist()
{
	$table = "wra_groups";
	global $wpdb;
	$table_name = $wpdb->base_prefix . $table;
	$query = $wpdb->prepare('SHOW TABLES LIKE %s', $wpdb->esc_like($table_name));

	if (!$wpdb->get_var($query) == $table_name) {

		$charset_collate = $wpdb->get_charset_collate();
		$sql = "CREATE TABLE IF NOT EXISTS `{$wpdb->base_prefix}{$table}` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
			`group_id` bigint(20) NOT NULL,
			`title` varchar(255) NOT NULL,
			`groupParentID` bigint(20) NOT NULL,
			`siteGroupId` bigint(20) NOT NULL,
			PRIMARY KEY (id)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
			";
		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		dbDelta($sql);
		$is_error = empty($wpdb->last_error);

		$sql = "ALTER TABLE `{$wpdb->base_prefix}{$table}` ADD INDEX(`group_id`, `groupParentID`, `siteGroupId`);";
		$wpdb->query($sql);


	}
}
function wra_check_reports_table_exist()
{

	$table = "wra_reports";
	global $wpdb;
	$table_name = $wpdb->base_prefix . $table;
	$query = $wpdb->prepare('SHOW TABLES LIKE %s', $wpdb->esc_like($table_name));

	if (!$wpdb->get_var($query) == $table_name) {

		$charset_collate = $wpdb->get_charset_collate();
		$sql = "CREATE TABLE IF NOT EXISTS `{$wpdb->base_prefix}{$table}` (
			`id` int(11) NOT NULL AUTO_INCREMENT,
			`queue_id` INT NOT NULL DEFAULT '0',
			`description` varchar(1000) NOT NULL,
			`action` varchar(255) NOT NULL,
			`insertTime` datetime NOT NULL,
			`updateTime` datetime NOT NULL DEFAULT current_timestamp(),
			`address` varchar(255) NOT NULL,
			`json` longtext NOT NULL,
			`response` longtext NOT NULL,	
			`status` varchar(20) NOT NULL,	
			PRIMARY KEY (id)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
			";

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		dbDelta($sql);
		$is_error = empty($wpdb->last_error);


		$sql = "ALTER TABLE `{$wpdb->base_prefix}{$table}` ADD INDEX(`queue_id`, `action`, `status`);";
		$wpdb->query($sql);

	}
}
function wra_check_queue_table_exist()
{
	$table = "wra_queue";
	global $wpdb;
	$table_name = $wpdb->base_prefix . $table;
	$query = $wpdb->prepare('SHOW TABLES LIKE %s', $wpdb->esc_like($table_name));

	if (!$wpdb->get_var($query) == $table_name) {

		$charset_collate = $wpdb->get_charset_collate();
		$sql = "CREATE TABLE IF NOT EXISTS `{$wpdb->base_prefix}{$table}` (
			`id` int(11) NOT NULL AUTO_INCREMENT,
			`url` varchar(255) NOT NULL,
			`method` varchar(10) NOT NULL,
			`data` longtext NOT NULL,
			`retry` int(11) NOT NULL DEFAULT '0',
			`status` int(11) NOT NULL,
			`created_at` datetime NOT NULL,
			`send_at` datetime NOT NULL,
			PRIMARY KEY (id)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
			";

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		dbDelta($sql);
		$is_error = empty($wpdb->last_error);
	}
}
function wra_check_queue_product_table_exist()
{
	$table = "wra_queue_products";
	global $wpdb;
	$table_name = $wpdb->base_prefix . $table;
	$query = $wpdb->prepare('SHOW TABLES LIKE %s', $wpdb->esc_like($table_name));

	if (!$wpdb->get_var($query) == $table_name) {
		$charset_collate = $wpdb->get_charset_collate();
		$sql = "CREATE TABLE IF NOT EXISTS `{$wpdb->base_prefix}{$table}` (
			`id` int(11) NOT NULL AUTO_INCREMENT,			
			`queue_id` int(11) NOT NULL DEFAULT '0',
			`product_id` int(11) NOT NULL DEFAULT '0',
			`counts` int(11) NOT NULL DEFAULT '0',
			PRIMARY KEY (id)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
			";

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		dbDelta($sql);
		$is_error = empty($wpdb->last_error);

		$sql = "ALTER TABLE `{$wpdb->base_prefix}{$table}` ADD INDEX(`queue_id`, `product_id`);";
		$wpdb->query($sql);


	}
}
function wra_check_products_map_table_exist()
{
	$table = "wra_products_map";
	global $wpdb;
	$table_name = $wpdb->base_prefix . $table;
	$query = $wpdb->prepare('SHOW TABLES LIKE %s', $wpdb->esc_like($table_name));

	if (!$wpdb->get_var($query) == $table_name) {

		$charset_collate = $wpdb->get_charset_collate();
		$sql = "CREATE TABLE IF NOT EXISTS `{$wpdb->base_prefix}{$table}` (
			`id` int(11) NOT NULL AUTO_INCREMENT,
			`productId` int(11) NOT NULL,
  			`apiProductId` int(11) NOT NULL,
  			`ProductCnuId` int(11) NOT NULL,	
			`productCode` VARCHAR(255) NULL DEFAULT '',				
			PRIMARY KEY (id)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
			";

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		dbDelta($sql);
		$is_error = empty($wpdb->last_error);

		$sql = "ALTER TABLE `{$wpdb->base_prefix}{$table}` ADD INDEX(`productId`, `apiProductId`, `ProductCnuId`);";
		$wpdb->query($sql);
	}

	
	$column_name = 'productCode';
	$column_definition = "VARCHAR(255) NULL DEFAULT ''";
	$row = $wpdb->get_results("SHOW COLUMNS FROM `$table_name` LIKE '$column_name'");
	if (empty($row)) {
		$wpdb->query("ALTER TABLE `$table_name` ADD `$column_name` $column_definition");
	}



	
}
function wra_insert_multiple_rows($table, $request)
{
	global $wpdb;
	$column_keys = '';
	$column_values = '';
	$sql = '';
	$last_key = array_key_last($request);
	$first_key = array_key_first($request);
	foreach ($request as $k => $value) {
		$keys = array_keys($value);

		// Prepare column keys & values.
		foreach ($keys as $v) {
			$column_keys .= sanitize_key($v) . ',';
			$sanitize_value = sanitize_text_field($value[$v]);
			$column_values .= is_numeric($sanitize_value) ? $sanitize_value . ',' : "'$sanitize_value'" . ',';
		}
		// Trim trailing comma.
		$column_keys = rtrim($column_keys, ',');
		$column_values = rtrim($column_values, ',');
		if ($first_key === $k) {
			$sql .= "INSERT INTO {$table} ($column_keys) VALUES ($column_values)";
		} elseif ($last_key == $k) {
			$sql .= "($column_values)";
		} else {
			$sql .= ",($column_values)";
		}

		// Reset keys & values to avoid duplication.
		$column_keys = '';
		$column_values = '';
	}

	return $wpdb->query($sql);
}
function wra_update_multiple_row($table, $request, $where)
{
	global $wpdb;
	$columns = '';
	$sql = '';
	$i = 0;
	foreach ($request as $key => $v) {
		if ($i) $columns .= ',';
		
		$columns .= "{$key} = '{$v}' ";
		$i = 1;
	}
	$sql = "UPDATE {$table} set {$columns} WHERE {$where}";

	return $wpdb->query($sql);
}
function wra_delete_multiple_row($table, $where)
{
	global $wpdb;
	$sql = "DELETE FROM {$table} WHERE {$where}";
	return $wpdb->query($sql);
}



function wra_get_table_size($table_name)
{
	require_once ABSPATH . '/wp-config.php';
	global $wpdb;
	$table_name = $wpdb->base_prefix . $table_name;
	$sql = '
	SELECT 
			table_name AS "Table", 
			ceil(SUM(data_length + index_length) * 1000 / 1024 / 1024)  AS "table_size"
		FROM 
			information_schema.tables 
		WHERE 
			table_schema = "'.DB_NAME.'" 
			AND table_name = "'.$table_name .'"
		GROUP BY table_name';
	
	$result = $wpdb->get_results($sql);
	if($result) return number_format(floatval($result[0]->table_size)).' کیلوبایت';
	else 
	return '---';
}


function wra_get_image($base64_img)
{
    
    $title =time();

	// Upload dir.
	$upload_dir  = wp_upload_dir();
	$upload_path = str_replace( '/', DIRECTORY_SEPARATOR, $upload_dir['path'] ) . DIRECTORY_SEPARATOR;

	$img             = str_replace( 'data:image/jpeg;base64,', '', $base64_img );
	$img             = str_replace( ' ', '+', $img );
	$decoded         = base64_decode( $img );
	$filename        = $title . '.jpeg';
	$file_type       = 'image/jpeg';
	$hashed_filename = md5( $filename . microtime() ) . '_' . $filename;

	// Save the image in the uploads directory.
	$upload_file = file_put_contents( $upload_path . $hashed_filename, $decoded );

	$attachment = array(
		'post_mime_type' => $file_type,
		'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $hashed_filename ) ),
		'post_content'   => '',
		'post_status'    => 'inherit',
		'guid'           => $upload_dir['url'] . '/' . basename( $hashed_filename )
	);

	$attach_id = wp_insert_attachment( $attachment, $upload_dir['path'] . '/' . $hashed_filename );
	
	require_once(ABSPATH . 'wp-admin/includes/image.php');
	$attach_data = wp_generate_attachment_metadata($attach_id, $upload_dir['path'] . '/' . $hashed_filename);
	wp_update_attachment_metadata($attach_id, $attach_data);
	
	
    return $attach_id;
}

function wra_get_image_url($image_url)
{
	$upload_dir = wp_upload_dir();

	$image_data = file_get_contents($image_url);

	$filename = basename($image_url);

	if (wp_mkdir_p($upload_dir['path'])) {
		$file = $upload_dir['path'] . '/' . $filename;
	} else {
		$file = $upload_dir['basedir'] . '/' . $filename;
	}

	file_put_contents($file, $image_data);

	$wp_filetype = wp_check_filetype($filename, null);

	$attachment = array(
		'post_mime_type' => $wp_filetype['type'],
		'post_title' => sanitize_file_name($filename),
		'post_content' => '',
		'post_status' => 'inherit'
	);

	$attach_id = wp_insert_attachment($attachment, $file);
	require_once(ABSPATH . 'wp-admin/includes/image.php');
	$attach_data = wp_generate_attachment_metadata($attach_id, $file);
	wp_update_attachment_metadata($attach_id, $attach_data);
	return $attach_id;
}

function wra_fix_letter($word)
{
    $word = str_replace('ك','ک',$word);
    $word = str_replace('ي','ی',$word);
    return trim($word);
}

function wra_notice($message, $type)
{
	add_action('admin_notices', function () use ($message, $type) {
?>
<div class="notice notice-<?php echo $type; ?> is-dismissible">
	<p><?php echo $message ?></p>
</div>
<?php
	});
 

}

function wra_software_price($price)
{
	$unit = 1;
	$wra_priceInWC = get_option('woocommerce_currency');
	$wra_priceInApp = get_option('wra_priceInApp');
	if ($wra_priceInWC == 'IRR')
		$unit /= 10;
	if ($wra_priceInApp == 'ریال')
		$unit *= 10;

	return $price*$unit;
}
function wra_site_price($price)
{
	$unit = 1;
	$wra_priceInWC = get_option('woocommerce_currency');
	$wra_priceInApp = get_option('wra_priceInApp');
	if ($wra_priceInWC == 'IRR')
		$unit *= 10;
	if ($wra_priceInApp == 'ریال')
		$unit /= 10;

	return $price*$unit;
}







// آپدیت قیمت کالاها براساس قیمت طلا
function wra_update_products_with_gold_price($product_id = 0) {
    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        'fields'         => 'ids',
    );

	$gold_price = wra_gold_price();	




	if($product_id)
		$products = [$product_id];
	else
    	$products = get_posts($args); 



    foreach ($products as $product_id) {

		
		//if(get_post_meta($product_id, 'online_gold_price', true) == 1)
		//{

				$final_price = wra_calculate_price_datails($product_id, $gold_price);
				
				


				// بروزرسانی قیمت در متا و خود محصول
				// update_post_meta($product_id, '_regular_price', $final_price['TotalPrice'] - $final_price['DiscountMoney']);		
				// update_post_meta($product_id, '_sale_price', $final_price['TotalPrice']);
				// update_post_meta($product_id, '_price', $final_price['TotalPrice']);


				$regular_price = $final_price['TotalPrice'];
				$sale_price = $final_price['TotalPrice'];
				
				// $product = wc_get_product($product_id);
				
				// $product->set_regular_price($regular_price);
				// $product->set_price(wra_site_price($sale_price));	
				// $product->set_sale_price($sale_price); // اگر تخفیف دارید
				// $product->save();




				// $product = wc_get_product($product_id);
				// if ($product && $product instanceof WC_Product) {
					
				// 	$product->set_regular_price($regular_price);
				// 	$product->set_sale_price($sale_price);
				// 	// $product->set_price($sale_price);				
				// 	$product->save();
				// 	wc_delete_product_transients($product_id);
				// }



		
					global $wpdb;

				// var_dump([$product_id,$regular_price,$sale_price,$wpdb]);die;	
				
				
					$result1 = $wpdb->update(
						$wpdb->postmeta,
						[
							'meta_value' => $regular_price,
						],
						[
							'post_id' => $product_id,
							'meta_key' => '_regular_price',
						]
					);

					if ($result1 === 0 || $result1 === false) {
						$wpdb->insert(
							$wpdb->postmeta,
							[
								'post_id' => $product_id,
								'meta_key' => '_regular_price',
								'meta_value' => $regular_price,
							]
						);
					}


					

					$result2 = $wpdb->update(
						$wpdb->postmeta,
						[
							'meta_value' => $sale_price,
						],
						[
							'post_id' => $product_id,
							'meta_key' => '_sale_price',
						]
					);

					if ($result2 === 0 || $result2 === false) {
						$wpdb->insert(
							$wpdb->postmeta,
							[
								'post_id' => $product_id,
								'meta_key' => '_sale_price',
								'meta_value' => $sale_price,
							]
						);
					}


					$result3 = $wpdb->update(
						$wpdb->postmeta,
						[
							'meta_value' => $sale_price ?: $regular_price,
						],
						[
							'post_id' => $product_id,
							'meta_key' => '_price',
						]
					);


					if ($result3 === 0 || $result3 === false) {
						$wpdb->insert(
							$wpdb->postmeta,
							[
								'post_id' => $product_id,
								'meta_key' => '_price',
								'meta_value' => $sale_price ?: $regular_price,
							]
						);
					}



					wc_delete_product_transients($product_id);





				
			
				// update_post_meta($product_id, '_regular_price', $regular_price);
				// update_post_meta($product_id, '_price', $sale_price);
				// update_post_meta($product_id, '_sale_price', $sale_price);
				



				


				// $product = wc_get_product($product_id);
				// if ($product && !$product->is_type('variable')) {
				// 	$product->set_price($final_price);
				// 	$product->set_regular_price($final_price);
				// 	$product->set_sale_price( '' );				
				// 	$product->save();
				// }

				//wc_delete_product_transients( $product_id );
			
        
		//}

    }
}


// شورت کد لیست قیمت
function gold_list_shortcode()
{
	
	if(get_option('wra_gold_api_list'))
	{
	
		$data_list = json_decode(get_option('wra_gold_api_list'));
		$table_list = [];	
		if($data_list)
			foreach($data_list as $key=>$list)
			{
				if($list) $list = intval($list);

				switch($key)
				{
					case 'SekehRob': $table_list[] = '<tr><td>ربع سکه</td><td>'.number_format($list*1000).' تومان</td></tr>'; break;
					case 'SekehNim': $table_list[] = '<tr><td>نیم سکه</td><td>'.number_format($list*1000).' تومان</td></tr>'; break;
					case 'SekehTamam': $table_list[] = '<tr><td>سکه بهار آزادی</td><td>'.number_format($list*1000).' تومان</td></tr>'; break;
					case 'SekehEmam': $table_list[] = '<tr><td>سکه امامی</td><td>'.number_format($list*1000).' تومان</td></tr>'; break;
					case 'YekGram18': $table_list[] = '<tr><td>طلای 18 عیار</td><td>'.number_format($list).' تومان</td></tr>'; break;
					// case 'KharidMotefaregheh18': $table_list[] = '<tr><td></td><td>'.$list.'</td></tr>'; break;
					// case 'TavizMotefaregheh18': $table_list[] = '<tr><td></td><td>'.$list.'</td></tr>'; break;
					case 'YekGram20': $table_list[] = '<tr><td>طلای 24 عیار</td><td>'.number_format($list).' تومان</td></tr>'; break;
					case 'SekehGerami': $table_list[] = '<tr><td>سکه گرمی</td><td>'.number_format($list*1000).' تومان</td></tr>'; break;
					// case 'YekGram21': $table_list[] = '<tr><td></td><td>'.$list.'</td></tr>'; break;
					// case 'Dollar': $table_list[] = '<tr><td>دلار</td><td>'.$list.'</td></tr>'; break;
					// case 'Euro': $table_list[] = '<tr><td>یورو</td><td>'.$list.'</td></tr>'; break;
					// case 'Derham': $table_list[] = '<tr><td>درهم</td><td>'.$list.'</td></tr>'; break;
					// case 'OunceTala': $table_list[] = '<tr><td>انس طلا</td><td>'.$list.'</td></tr>'; break;
					


					case 'Geram18': $table_list[] = '<tr><td>طلای 18 عیار</td><td>'.number_format($list).' تومان</td></tr>'; break;
					// case 'Mazane': $table_list[] = '<tr><td></td><td>'.$list.'</td></tr>'; break;
					// case 'Taviz': $table_list[] = '<tr><td></td><td>'.$list.'</td></tr>'; break;
					// case 'Kharid': $table_list[] = '<tr><td></td><td>'.$list.'</td></tr>'; break;
					case 'SekeGhadim': $table_list[] = '<tr><td>سکه طرح قدیم</td><td>'.number_format($list).' تومان</td></tr>'; break;
					case 'Tamam': $table_list[] = '<tr><td>سکه بهار آزادی</td><td>'.number_format($list).' تومان</td></tr>'; break;
					case 'Nim': $table_list[] = '<tr><td>نیم سکه</td><td>'.number_format($list).' تومان</td></tr>'; break;
					case 'NimZir86': $table_list[] = '<tr><td>نیم سکه (قبل از 86)</td><td>'.$list.' تومان</td></tr>'; break;
					case 'Rob': $table_list[] = '<tr><td>ربع سکه</td><td>'.number_format($list).' تومان</td></tr>'; break;
					case 'RobZir86': $table_list[] = '<tr><td>ربع سکه (قبل از 86)</td><td>'.number_format($list).' تومان</td></tr>'; break;
					case 'YekGerami': $table_list[] = '<tr><td>سکه گرمی</td><td>'.number_format($list).' تومان</td></tr>'; break;
					// case 'Ons': $table_list[] = '<tr><td>انس طلا</td><td>'.number_format($list).' تومان</td></tr>'; break;
					// case 'Dollar': $table_list[] = '<tr><td>دلار</td><td>'.$list.'</td></tr>'; break;
					// case 'Euro': $table_list[] = '<tr><td>یورو</td><td>'.$list.'</td></tr>'; break;
					// case 'Lir': $table_list[] = '<tr><td>لیر ترکیه</td><td>'.$list.'</td></tr>'; break;
					// case 'Derham': $table_list[] = '<tr>درهم امارات<td></td><td>'.$list.'</td></tr>'; break;
					// case 'SadDinar': $table_list[] = '<tr><td>دینار عراق</td><td>'.$list.'</td></tr>'; break;
					// case 'Yuan': $table_list[] = '<tr><td>یوان چین</td><td>'.$list.'</td></tr>'; break;
					// case 'Geram875': $table_list[] = '<tr><td></td><td>'.$list.'</td></tr>'; break;
					// case 'Geram995': $table_list[] = '<tr><td></td><td>'.$list.'</td></tr>'; break;
					// case 'Geram999': $table_list[] = '<tr><td></td><td>'.$list.'</td></tr>'; break;
					// case 'Noghre990': $table_list[] = '<tr><td></td><td>'.$list.'</td></tr>'; break;
					// case 'Pure': $table_list[] = '<tr><td></td><td>'.$list.'</td></tr>'; break;
				


				}
			}

			return '<table><tr><th>سکه و طلا</th><th>قیمت</th></tr>'.implode('',$table_list).'</table>';

		
	}
}



function wra_calculate_price($product_id, $gold_price, $Count = 1)
{
	$price_datails = wra_calculate_price_datails($product_id, $gold_price, $Count);
	return $price_datails['TotalPrice'];
}




function wra_calculate_price_datails($product_id, $gold_price, $Count = 1)
{

    $product = wc_get_product($product_id);

	


	if(
		$product_id && 
		$product && 
		$product->get_name() !='AUTO-DRAFT' &&
		$gold_price > 0 &&
		floatval(get_post_meta($product_id, '_weight', true)) > 0
	)
	{
		// وزن مجموع=وزن * تعداد خرید
		$Weight = floatval(get_post_meta($product_id, '_weight', true)) * $Count;

		// درصد اجرت درصدی 
		$PercentWage = floatval(get_post_meta($product_id, 'ProductSaleFeePercent', true));

		// عیار طلا
		$Cutie = intval(get_post_meta($product_id, 'ProductCutie', true));

		// عیار مرجع 
		$ReferenceCutie = intval(get_option('ReferenceCutie'));
		if(!$ReferenceCutie) $ReferenceCutie = 750; 

		// قیمت روز طلا 
		$UnitPrice = $gold_price;

		// نوع اجرت
		$WageKind = intval(get_post_meta($product_id, 'ProductSaleFeeType', true));

		// نوع سود
		$ProfitKind = intval(get_post_meta($product_id, 'ProductProfitKind', true));

		// مبلغ اجرت ریالی
		$WageMoney = intval(get_post_meta($product_id, 'ProductSaleFeeValue', true));

		// ارزش ریالی سنگ ها
		$StonePrice = intval(get_post_meta($product_id, 'ProductRockRialCost', true)) * $Count;

		// ارزش ریالی چرم 
		$LeatherPrice = intval(get_post_meta($product_id, 'ProductLeatherRialCost', true)) * $Count;
		
		// ارزش ریالی نقره
		$SilverPrice = intval(get_post_meta($product_id, 'ProductSilverRialCost', true)) * $Count;

		// مقدار سود
		$Profit = floatval(get_post_meta($product_id, 'ProductProfitValue', true));

		// معاف از مالیات در فروش
		$ProductExemptOnSale = get_post_meta($product_id, 'ProductExemptOnSale', true);

		// نحوه محاسبه مالیات بر ارزش افزوده
		$ProductCalcTaxTollType = intval(get_post_meta($product_id, 'ProductCalcTaxTollType', true));

		// مالیات 
		$TaxPercent  = floatval(get_post_meta($product_id, 'ProductTax', true));

		// قیمت بر اساس عیار طلا 
		//قیمت جدید = (عیار طلا / عیار مرجع) * قیمت روز طلا
		$NewPrice = wra_Rounder(floor(($Cutie / $ReferenceCutie) * $UnitPrice), 3); 


		// وزن به عیار مرجع 
		// وزن به عیار مرجع = (عیار طلا / عیار مرجع * مجموع وزن طلا)
		$RefWeight = wra_Rounder(($Cutie / $ReferenceCutie * $Weight ), 3);

		////////////////گرم اجرت درصدی
		// گرم اجرت درصدی = (وزن مجموع * درصد اجرت وزنی) / 100
		$PercentWageRefWeight = wra_Rounder((($RefWeight * $PercentWage) / 100),3);

		//////////////// ریال اجرت درصدی 
		// ریال اجرت درصدی = (قیمت جدید * مجموع وزن * درصد اجرت درصدی ) / 100
		$PercentWageMoney = wra_Rounder(floor(($NewPrice) * $Weight * ($PercentWage / 100)), 0);


		//echo '0='.$NewPrice.',1='.$Weight.' '.$PercentWage.',2='.(($NewPrice) * $Weight * ($PercentWage / 100)). ',3='.floor(($NewPrice) * $Weight * ($PercentWage / 100)).',4='.$PercentWageMoney;die;

		// نوع تخفیف
		$DiscountType  = intval(get_post_meta($product_id, 'DiscountType', true));
		// درصد تخفیف
		$DiscountMoney  = floatval(get_post_meta($product_id, 'DiscountMoney', true));


		
		/////////////// سود درصدی
		///////////////////1- نوع اجرت در فروش وزنی باشد (1) و سود درصدی باشد 
		// جمع اجرت ها = (مبلغ اجرت درصدی + (مبلغ اجرت ریالی * مجموع وزن طلا) + (قیمت بر اساس عیار طلا * مجموع وزن طلا)
		// سود = ((جمع اجرت ها + ارزش ریالی سنگ + ارزش ریالی چرم + ارزش ریالی نقره ) * درصد سود ) / 100 
		$ProfitMoney = 0;	
		$ProfitPercent = 0;
		if($WageKind == 1 && $ProfitKind == 0)
		{
			$ProfitPercent = $Profit;
			$ProfitMoney = wra_Rounder(floor(
			(	
				(
					$PercentWageMoney + ($WageMoney * $Weight) + ($NewPrice * $Weight) +
					$StonePrice + $LeatherPrice + $SilverPrice
				) * $Profit
			) / 100), 0);
		}

		///////////////////2- نوع اجرت در فروش تعدادی باشد (2) و سود درصدی باشد
		// سرجمع اجرت ها = (قیمت بر اساس عیار طلا * مجموع وزن) + مبلغ اجرت ریالی + (مبلغ اجرت ریالی * تعداد طلا)
		// سرجمع اجرت ها و اضافات  = (جمع اجرت ها + ارزش ریالی سنگ + ارزش ریالی چرم + ارزش ریالی نقره )
		// سود = (سرجمع اجرت ها و اضافات   * درصد سود ) / 100

		// var_dump([$WageKind,$ProfitKind,$PercentWageMoney,$WageMoney,$WageMoney,$NewPrice,$Weight,$StonePrice,$LeatherPrice,$SilverPrice,$Profit]);die;


		if($WageKind == 2 && $ProfitKind == 0)
		{
			$ProfitPercent = $Profit;
			$ProfitMoney = wra_Rounder(floor(
			(	(
					$PercentWageMoney + ($WageMoney * $Count) + ($NewPrice * $Weight) +  
					$StonePrice + $LeatherPrice + $SilverPrice
				) * $Profit
			) / 100), 0);
			
		}

		//var_dump([$WageKind,$ProfitKind]);die;


		///////////////////3- نوع اجرت در فروش وزنی باشد (1) و سود ریالی  باشد 
		// جمع اجرت ها = (مبلغ اجرت درصدی + (مبلغ اجرت ریالی * مجموع وزن طلا) + (قیمت بر اساس عیار طلا * مجموع وزن طلا)
		// سرجمع اجرت ها و اضافات  = (جمع اجرت ها + ارزش ریالی سنگ + ارزش ریالی چرم + ارزش ریالی نقره ) 
		// در صورتی که سرجمع اجرت ها و اضافات  مقدار صفر باشد، درصد سود صفر است و در غیر این صورت 
		// درصد سود = (مبلغ سود * 100 ) / سرجمع اجرت ها و اضافات  
		
		if($WageKind == 1 && $ProfitKind == 1 && 				
			($PercentWageMoney + ($WageMoney * $Weight) + ($NewPrice * $Weight) + $StonePrice + $LeatherPrice + $SilverPrice)
		)
		{

	
			$ProfitMoney = $Profit;
			$ProfitPercent = wra_Rounder(floor(
				$ProfitMoney * 100 / 
				(
					$PercentWageMoney + ($WageMoney * $Weight) + ($NewPrice * $Weight) +
					$StonePrice + $LeatherPrice + $SilverPrice
				)
			), 2);
				


		}

		///////////////////4- نوع اجرت در فروش تعدادی باشد (2) و سود ریالی  باشد 
		// سرجمع اجرت ها = (قیمت بر اساس عیار طلا * مجموع وزن) + مبلغ اجرت ریالی + (مبلغ اجرت ریالی * تعداد طلا)
		// سرجمع اجرت ها و اضافات  = (جمع اجرت ها + ارزش ریالی سنگ + ارزش ریالی چرم + ارزش ریالی نقره )
		// درصورتی که سرجمع اجرت ها و اضافات   صفر باشد ، درصد سود صفر است و در غیر اینصورت 
		// درصد سود = (مبلغ سود * 100 ) / سرجمع اجرت ها و اضافات   
		if($WageKind == 2 && $ProfitKind == 1)
		{
			$ProfitMoney = $Profit;

			$ProfitPercent = wra_Rounder(floor(
				$ProfitMoney * 100 / 
				(
					$PercentWageMoney + ($WageMoney * $Count) + ($NewPrice * $Weight) +  
					$StonePrice + $LeatherPrice + $SilverPrice
				)
				), 2);


	
	

		}

		// var_dump($WageKind,$ProfitKind,$ProfitMoney,$PercentWageMoney,$WageMoney,$Count,$NewPrice
		// ,$Weight,$StonePrice,$LeatherPrice,$SilverPrice,$ProfitPercent);die;


		// مجموع اجرت 
		// -	اگر نوع اجرت در فروش وزنی باشد 
		// مجموع اجرت = (مبلغ اجرت ریالی * مجموع وزن طلا) + مبلغ اجرت درصدی
		// در صورتی که نوع اجرت در فروش، وزنی باشد 
		// جمع اجرت ها = (مبلغ اجرت ریالی * وزن طلا) + مبلغ اجرت درصدی 
		$SumWage = 0;
		if($WageKind == 1)
		{
			$SumWage = wra_Rounder(floor(($WageMoney * $Weight) + $PercentWageMoney), 0);
		}
		// در صورتی که نوع اجرت در فروش، تعدادی باشد
		// جمع اجرت ها = (مبلغ اجرت ریالی * تعداد طلا) + مبلغ اجرت درصدی 
		if($WageKind == 2)
		{
			$SumWage = wra_Rounder(floor(($WageMoney * $Count) + $PercentWageMoney), 0);  
		}

		// محاسبه مالیات 
		//تمامی محاسبات در صورتی است که نحوه محاسبه مالیات بر ارزش افزوده   = 1 (اجرت و سود) باشد 
		$TaxMoney = 0;
		if($ProductCalcTaxTollType == 1)
		{
			if($ProductExemptOnSale != 1)
			{

  
				//  مبلغ مالیات = ((جمع اجرت ها + مبلغ سود ) * درصد مالیات ) / 100
				$TaxMoney = wra_Rounder(floor((($SumWage + $ProfitMoney) * $TaxPercent) / 100), 0);
			}
		}





		// مبلغ خالص
		// مبلغ خالص = (مجموع وزن طلا * قیمت بر اساس عیار طلا) + ارزش ریالی سنگ + ارزش ریالی چرم + ارزش ریالی نقره + مجموع اجرت 
		$PurePrice = wra_Rounder( ($NewPrice * $Weight ) + $StonePrice + $LeatherPrice + $SilverPrice + $SumWage , 0);


		// مبلغ خالص به علاوه سود   
		// مبلغ خالص = (مجموع وزن طلا * قیمت بر اساس عیار طلا) + مبلغ سود + ارزش ریالی سنگ + ارزش ریالی چرم + ارزش ریالی نقره + مجموع اجرت 
		$GoldPrice_Wage_Profit =wra_Rounder( $ProfitMoney + ($NewPrice * $Weight ) + $StonePrice + $LeatherPrice + $SilverPrice + $SumWage , 0);


		// تخفیف درصدی
		if($DiscountType == 0)
		{
			$DiscountPercent = $DiscountMoney;
			$DiscountMoney = wra_Rounder(floor( $GoldPrice_Wage_Profit * $DiscountMoney / 100), 0);
		}
		else
		{
			$DiscountPercent = $GoldPrice_Wage_Profit ? wra_Rounder(($DiscountMoney * 100) / $GoldPrice_Wage_Profit, 2) : 0;
		}

	


		// مبلغ اضافات 
		// مبلغ اضافات = مجموع اجرت + مبلغ سود + ارزش ریالی سنگ + ارزش ریالی چرم + ارزش ریالی نقره + مبلغ مالیات - مبلغ تخفیف
		$Addition = $SumWage + $ProfitMoney + $StonePrice + $LeatherPrice + $SilverPrice + $TaxMoney - $DiscountMoney;

		// var_dump([
		// 	$Addition , $SumWage , $ProfitMoney , $StonePrice , $LeatherPrice , $SilverPrice , $TaxMoney , $DiscountMoney
		// ]);die;


		// [0]=> float(8646375.99000000022351741790771484375) 
		// [1]=> float(0) 
		// [2]=> float(7860342) 
		// [3]=> int(0) 
		// [4]=> int(0) 
		// [5]=> int(0) 
		// [6]=> float(786034) 
		// [7]=> float(0.01000000000000000020816681711721685132943093776702880859375) }





		//مبلغ واحد به عیار مرجع 
		// مبلغ واحد به عیار مرجع = (عیار طلا / عیار مرجع * مبلغ طلا  قیمت طلا)
		$RefUnitPrice = wra_Rounder(($Cutie / $ReferenceCutie * $UnitPrice ), 0);

		// مبلغ نهایی 
		// مبلغ نهایی = مبلغ خالص به علاوه سود – مبلغ تخفیف + مبلغ مالیات 
		$TotalPrice = wra_Rounder(($GoldPrice_Wage_Profit - $DiscountMoney), 0) + $TaxMoney;




		return [
			"NewPrice" => $NewPrice,	//قیمت بر اساس عیار طلا 
			"PercentWageRefWeight" =>$PercentWageRefWeight, //گرم اجرت درصدی
			"PercentWageMoney" => $PercentWageMoney, // ریال اجرت درصدی 
			"ProfitMoney" => $ProfitMoney, //سود
			"ProfitPercent" => $ProfitPercent, // درصد سود
			"Profit" => $Profit,
			"TaxMoney" => $TaxMoney, // مالیات
			"RefWeight" => $RefWeight, //وزن به عیار مرجع 
			"RefUnitPrice" => $RefUnitPrice, //مبلغ واحد به عیار مرجع 
			"DiscountMoney" => $DiscountMoney, // مبلغ تخفیف
			"DiscountPercent" => $DiscountPercent, // درصد تخفیف
			"PurePrice" => $PurePrice, //مبلغ خالص
			"Addition" => $Addition, //مبلغ اضافات 
			"GoldPrice_Wage_Profit" => $GoldPrice_Wage_Profit, //مبلغ خالص به علاوه سود   
			"TotalPrice" => $TotalPrice, //مبلغ نهایی 
			"SumWage" => $SumWage, // مبلغ اجرت
		];
	}
	else
	{
		return [
			"NewPrice" => 0,	//قیمت بر اساس عیار طلا 
			"PercentWageRefWeight" =>0, //گرم اجرت درصدی
			"PercentWageMoney" => 0, // ریال اجرت درصدی 
			"ProfitMoney" => 0, //سود
			"Profit" => 0,
			"ProfitPercent" => 0, // درصد سود
			"TaxMoney" => 0, // مالیات
			"RefWeight" => 0, //وزن به عیار مرجع 
			"RefUnitPrice" => 0, //مبلغ واحد به عیار مرجع 
			"DiscountMoney" => 0,
			"DiscountPercent" => 0,
			"PurePrice" => 0, 
			"Addition" => 0, 
			"GoldPrice_Wage_Profit" => 0, 
			"TotalPrice" => 0, 
			"SumWage" => 0,
		];


	}

}




function wra_gold_price()
{
	$gold_price = intval(get_option('wra_gold_price'));
	$wra_priceInWC = get_option('woocommerce_currency');
	if($wra_priceInWC== 'IRR') $gold_price *= 10;

	$check_time = (time() - get_option('wra_gold_price_time'))/60 ;


	if(
		get_option('wra_reset_price')>0 && 
		get_option('wra_gold_price_time') &&  
		$check_time > get_option('wra_reset_price')
	)
		$gold_price = 0;


	return $gold_price;
}


function wra_Rounder(float $value, int $decimals) {
    $a = 1;

    if ($decimals === 0) {
        $a = 1;
    } elseif ($decimals === 1) {
        $a = 10;
    } else {
        for ($j = 1; $j <= $decimals; $j++) {
            $a *= 10;
        }
    }

    return floor($value * $a + 0.5) / $a;
}



function wra_update_order_count($goldItem, $count)
{
		//قیمت سنگ ها
		$goldItem["StonePrice"] = $goldItem["StonePrice"] * $count;
		//جمع اجرت ها
		$goldItem["SumWageItem"] = $goldItem["SumWageItem"] * $count;
		//مبلغ خالص
		$goldItem["PurePrice"] = $goldItem["PurePrice"] * $count;
		//مبلغ اضافات
		$goldItem["Addition"] = $goldItem["Addition"] * $count;
		//مبلغ خالص + سود
		$goldItem["GoldPriceWageProfit"] = $goldItem["GoldPriceWageProfit"] * $count;
		//مبلغ نهایی 
		$goldItem["TotalPrice"] = $goldItem["TotalPrice"] * $count;
		//مبلغ سود
		$goldItem["ProfitMoney"] = $goldItem["ProfitMoney"] * $count;					
		//مبلغ مالیات 
		$goldItem["TaxMoney"] = $goldItem["TaxMoney"] * $count;
		//مبلغ تخفیف 
		$goldItem["DiscountMoney"] = $goldItem["DiscountMoney"] * $count;
		//ارزش ریالی چرم
		$goldItem["LeatherPrice"] = $goldItem["LeatherPrice"] * $count;
		//ارزش ریالی نقره
		$goldItem["SilverPrice"] = $goldItem["SilverPrice"] * $count;
		return $goldItem;

}

