<?php

class pejvakApi
{
	private $con = null;
	private $API_KEY = null;
	private $PLUGIN_KEY = null;
	private $IV = null;
	private $URL = null;
	private $PATH = '';	
	private $API_VERSION = '1';
	public function __construct($API_KEY, $IP, $PORT = null)
	{
		$this->API_KEY = $API_KEY;
		$this->PLUGIN_KEY = 'dfe3eb43e87582a2297d72ce';
		$this->IV = 'de817e3bd9848a243e3444c18c1f8905';
		$this->PATH = '/WebApiService/api/v'.$this->API_VERSION; 
		$this->URL = $IP;
		if ($PORT && $PORT!=80)
			$this->URL .= ':' . $PORT;
		$this->connect();

	}
	public function connect()
	{

	}
	public function get($url, $data = null, $method = 'GET')
	{
	    
		$url = 'http://' . $this->URL . $url;

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

		curl_setopt($ch, CURLOPT_VERBOSE, 0);


		curl_setopt($ch, CURLOPT_TIMEOUT, 5000);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);


		if ($data) {
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
		}

		if ($method == 'POST')
			curl_setopt($ch, CURLOPT_POST, 1);
		else
			curl_setopt($ch, CURLOPT_POST, 0);

		$response = curl_exec($ch);

		global $wra_http_status;
		$wra_http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);

		return $response;

	}


	public function wra_check_connection($url)
	{
		$url = 'http://'.$url.'/WebApiService/api/v1/TimeStamp/ConnectToDatabase';

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

		curl_setopt($ch, CURLOPT_VERBOSE, 0);

		curl_setopt($ch, CURLOPT_TIMEOUT, 20);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_POST, 0);

		$result=[];
		$response = curl_exec($ch);
		$result['data']=$response;
		global $wra_http_status;
		$wra_http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		if ($wra_http_status == 200) {
			if ($response == 'The connection to the database was successful')
				$result['state']=1;
			else {
				$result['state']=-1;
			}
		}
		else
		{
			$result['state']=-2;
		}
		return $result;
	}

	public function getTimeStamp()
	{
		$response = $this->get($this->PATH . '/TimeStamp');

		if (!empty($response))
			return intval($response);
		else
			return 0;
	}


	public function getToket()
	{
		$TimeStamp = $this->getTimeStamp();

		if ($TimeStamp) {
			$data = [
				"PluginName" => "PrinceWP",
				"PluginPlatform" => "Wordpress",
				"PluginVersion" => "1.0.7a",
				"Author" => "Pejvak",
				"UserId" => 1,
				"ApiKey" => md5($this->API_KEY),
				"TimeStamp" => $TimeStamp
			];


			$encode_data = pack('H*', md5(json_encode($data)));

			// ساخت کلید مبتنی بر زمان
			$TimeStamp = dechex($TimeStamp);
			$key = pack('H*', $TimeStamp . $this->PLUGIN_KEY);

			// ایجاد IV
			$iv = pack('H*', $this->IV);

			// ایجاد Mac 
			//$mac = mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $key, $data, MCRYPT_MODE_CBC, $iv);
			$mac = base64_decode(openssl_encrypt($encode_data, 'AES-128-CBC', $key, OPENSSL_ZERO_PADDING, $iv));
			$mac = bin2hex($mac);


			// ارسال دیتا به وب سرویس
			$data['Mac'] = $mac;


			$data = json_encode($data);

			$response = $this->get($this->PATH . '/Plugin/CheckPlugin', $data, 'POST');
            

            $insertTime = date('Y-m-d H:i:s', current_time('timestamp'));
            global $wra_http_status;
            wra_add_report('Get Token', $insertTime, $this->URL.$this->PATH . '/Plugin/CheckPlugin', $data, $response , $wra_http_status);

			if (!empty($response)) {
				$responseArray = json_decode($response, true);
				$mac = (String) $responseArray['mac'];
				$tokenId = (String) $responseArray['tokenId'];

				// create new key
				$TimeStamp = intval($responseArray['timeStamp']);
				$TimeStamp_hex = dechex($TimeStamp);

				$mac = pack('H*', $mac);
				$key = pack('H*', $TimeStamp_hex . $this->PLUGIN_KEY);
				$iv = pack('H*', $this->IV);

				//$result = mcrypt_decrypt(MCRYPT_RIJNDAEL_128, $key, hex2bin($mac), MCRYPT_MODE_CBC, $iv);
				$result = openssl_decrypt($mac, 'AES-128-CBC', $key, 3, $iv); //OPENSSL_RAW_DATA
				$token = bin2hex($result);

				//$new_mac = mcrypt_encrypt(MCRYPT_RIJNDAEL_128, hex2bin($token),hex2bin(md5($tokenId)), MCRYPT_MODE_CBC, $iv);
				$new_mac = base64_decode(openssl_encrypt(hex2bin(md5($tokenId)), 'AES-128-CBC', hex2bin($token), OPENSSL_ZERO_PADDING, $iv));
				$new_mac = bin2hex($new_mac);

				return ['tokenId' => $tokenId, 'token' => $token, 'wra_token_time'=>$TimeStamp, 'mac' => $new_mac, 'resMsg'=>$responseArray['resMsg']];			
			}
		}
		else
		{
            $insertTime = date('Y-m-d H:i:s', current_time('timestamp'));
            wra_add_report('Get TimeStamp', $insertTime, $this->URL.$this->PATH . '/TimeStamp','', 'Fail to Connect');
		}
		
		return null;
	}


	function encrypt_data($cipherText, $key)
	{
		$cipherText = hex2bin($cipherText);
		$key = hex2bin($key);
		$iv = hex2bin($this->IV);

		$encrypted = bin2hex(base64_decode(openssl_encrypt($cipherText, 'AES-128-CBC', $key, OPENSSL_ZERO_PADDING, $iv)));

		return $encrypted;
	}
	function decrypt_data($cipherText, $key)
	{
		$cipherText = hex2bin($cipherText);
		$key = hex2bin($key);
		$iv = hex2bin($this->IV);
		$encrypted = bin2hex(base64_decode(openssl_decrypt($cipherText, 'AES-128-CBC', $key, 3, $iv)));
		return $encrypted;
	}


	public function GetProductGroups($mac, $tokenId)
	{
		$address = $this->PATH . '/GoldCommodity/GetProductGroups?mac=' . $mac . '&tokenId=' . $tokenId;
		$response = $this->get($address, null, 'GET');
		$insertTime = date('Y-m-d H:i:s', current_time('timestamp'));
		global $wra_http_status;
		wra_add_report('GetProductGroups', $insertTime, $this->URL.$address, '', $response,$wra_http_status);
		
		if (!empty($response))
			return json_decode($response);
		else
			return null;
	}


	public function GetProductsSimpleDetail($mac, $tokenId, $pageNumber = 1, $recordsPerPage = 10, $sortOrder = 0)
	{
		$response = $this->get($this->PATH . '/GoldCommodity/GetProductsSimpleDetail?mac=' . $mac . '&tokenId=' . $tokenId . '&pageNumber=' . $pageNumber . '&recordsPerPage=' . $recordsPerPage . '&sortOrder=' . $sortOrder);
		if (!empty($response))
			return json_decode($response);
		else
			return null;
	}

	public function GetProducts($mac, $tokenId, $pageNumber = 1, $recordsPerPage = 10, $sortOrder = 0)
	{
		$address = $this->PATH . '/GoldCommodity/GetProducts?mac=' . $mac . '&tokenId=' . $tokenId . '&pageNumber=' . $pageNumber . '&recordsPerPage=' . $recordsPerPage . '&sortOrder=' . $sortOrder;
		$response = $this->get($address);
		
        // حذف تصاویر از گزارش
        $responseReport = json_decode($response);
    
		if ($responseReport && !empty($responseReport->products)) 
			foreach ($responseReport->products as &$product) 
            {
                if(!empty($product->productImage))
                    $product->productImage = 'Array';    				    
            }
        $responseReport = json_encode($responseReport);



		$insertTime = date('Y-m-d H:i:s', current_time('timestamp'));
		global $wra_http_status;
		wra_add_report('GetProducts', $insertTime, $this->URL.$address, '', $responseReport,$wra_http_status);

		if (!empty($response))
			return json_decode($response);
		else
			return null;
	}



	public function GetProduct($mac, $tokenId, $productId)
	{
		$address = $this->PATH . '/GoldCommodity/GetProductById?mac=' . $mac . '&tokenId=' . $tokenId . '&productId=' . $productId;
		$response = $this->get($address);

		$insertTime = date('Y-m-d H:i:s', current_time('timestamp'));
		global $wra_http_status;
		wra_add_report('GetProductById', $insertTime, $this->URL.$address, '', $response,$wra_http_status);

		if (!empty($response))
			return json_decode($response);
		else
			return null;
	}


	public function sendFactor($data,$queue_id=0)
	{
		$address = $this->PATH . '/Factor/GoldFactorAdd';
		$response = $this->get($address, $data, 'POST');
		$insertTime = date('Y-m-d H:i:s', current_time('timestamp'));
		global $wra_http_status;
		wra_add_report('FactorAdd', $insertTime, $this->URL.$address, $data, $response,$wra_http_status,$queue_id);

		if (!empty($response))
			return json_decode($response);
		else
			return null;
	}

}
