<?php
class Wra_Product_class
{
	public function __construct()
	{

	}
	public function get_product($id)
	{
		$product = wc_get_product($id);
		return $product;
	}

	public function add_product($data)
	{
		if(get_option('wra_update_description')=='on')
		{


			$post_id = wp_insert_post(
				array(
					'post_title' => $data['name'],
					'post_content' => $data['description'] ? $data['description'] : "",
					'post_status' => $data['status'],
					'post_type' => "product",
				)
			);
		}
		else
		{
			$post_id = wp_insert_post(
				array(
					'post_title' => $data['name'],
					'post_status' => $data['status'],
					'post_type' => "product",
				)
			);
		}



		$product = wc_get_product($post_id);
		if($product)
			$this->update_fields($product, $data);


	}


	public function update_product($id, $data = null)
	{
		$param = array(
			'ID' => $id,
			//'post_status' => $data['status'],
		);


		if(get_option('wra_get_title')=='on')
		{
			$param['post_title'] = $data['name'];

		}

		if(get_option('wra_update_description')=='on')
		{
			$param['post_content'] = $data['description'];
		}

		wp_update_post($param);

		$product = wc_get_product($id);

		if($product)
			$this->update_fields($product, $data);
	
		

	}





	public function update_product_stock($product_id, $quantity)
	{
		global $woocommerce;
		$woocmmerce_instance = new WC_Product($product_id);
		$new_quantity = wc_update_product_stock($woocmmerce_instance, $quantity);

	}

	public function update_fields($product, $data = null)
	{
		global $wpdb;
		if ($data['productId']) {
			$query = "SELECT * FROM {$wpdb->base_prefix}wra_products_map where productCode='".$data['sku']."'";
			$result = $wpdb->get_results($query);

			try{
            	$product->set_sku($data['sku']);
			}catch (Exception $e) {
				if($is_new)
				{
					$new_sku = $data['sku'] . '_' . time();
					try{
						$product->set_sku($new_sku);
					}catch (Exception $e) {}
				}
			}

			if (!$result) {                
				$query = "INSERT INTO `{$wpdb->base_prefix}wra_products_map` (`productId`, `apiProductId`, `ProductCnuId`, `productCode`) VALUES ('{$product->get_id()}', '{$data['productId']}', '{$data['productUnitID']}', '{$data['sku']}');"; 
				$wpdb->query($query); 				
			}
			else
			{
				$query = "UPDATE `{$wpdb->base_prefix}wra_products_map` set `apiProductId`='{$data['productId']}', `ProductCnuId`='{$data['productUnitID']}', `productCode`='{$data['sku']}' where `productCode`='{$data['sku']}'";
				$wpdb->query($query);
			}


			wra_update_products_with_gold_price($product->get_id());

		}
	
		// $product->set_name($data['name']);
		// $product->set_status($data['status']);

		

	
		// if (get_option('wra_update_price')=='on')
		// {
		// 	$product->set_regular_price(wra_site_price($data['regular_price']));
		// 	if (get_option('wra_update_discount')=='on') {
		// 		$product->set_price(wra_site_price($data['price']));				
		// 		$product->set_sale_price(wra_site_price($data['sale_price']));			
		// 	}			
		// }
			
	
		

		$product->set_catalog_visibility('visible');

		$product->set_stock_status($data['stock_status']);
		$product->set_manage_stock($data['manage_stock']);
		$product->set_stock_quantity($data['stock_quantity']);

		
	

		// if (get_option('wra_update_images')=='on' && $product->get_id())
		// {
		// 	$p = wc_get_product( $product->get_id() );
		// 	if ( $p ) {
		// 		$featured_image_id = $p->get_image_id();
		// 		$image_galleries_id = $p->get_gallery_image_ids();
				
		// 		if( !empty( $featured_image_id ) ) {
		// 			wp_delete_post( $featured_image_id );
		// 		}
		// 		if( !empty( $image_galleries_id ) ) {
		// 			foreach( $image_galleries_id as $single_image_id ) {
		// 				wp_delete_post( $single_image_id );
		// 			}
		// 		}
		// 	}
			
		// 	if($data['image_id']) 
		// 		$product->set_image_id($data['image_id']);
		// }
	
		

	    $group_list = [];
		if (get_option('wra_update_groups')=='on')
		{
			if ($data['productGroups'])
			{
				foreach ($data['productGroups'] as $group) { 
					$query = "SELECT * FROM {$wpdb->base_prefix}wra_groups where group_id=" . intval($group->groupID).' limit 1';
					$result = $wpdb->get_results($query);
					
					if ($result && $result[0]->siteGroupId) {
						$groupId = get_cat_name(intval($result[0]->siteGroupId));
						//$groupId='';
						$term = get_term_by( 'id', intval($result[0]->siteGroupId), 'product_cat', 'ARRAY_A' );
						if(isset($term['name']))
							$groupId = $term['name'];
							
						$group_list[] = $groupId;
					}	
					else
					{ 
						$group_list[] = $group->groupName;
					}
				}
				if($group_list)
					wp_set_object_terms($product->get_id(), $group_list, 'product_cat');
			}
			else
			{
				$cat = get_term_by( 'id',get_option('default_product_cat'), 'product_cat' );
				if($cat)
					wp_set_object_terms($product->get_id(), $cat->name, 'product_cat');
			}
		
		}
	
		$product->update_meta_data("product_api_type", "1"); 



		if(isset($data['meta']) && $data['meta'])
			foreach((array)$data['meta'] as $key=>$meta)
				if($key)
				{
		
					update_post_meta($product->get_id(), $key, $meta);
				}
				


		$product->save();

	}


}