<?php

class tabanApi
{
    private $URL = 'https://webservice.tgnsrv.ir/Pr/Get/'; 

    public function get_price()
    {
        $result = json_decode($this->get()); 

		$url = $this->URL . get_option('wra_gold_web_service_password') . '/' . get_option('wra_gold_web_service_username');
		$insertTime = date('Y-m-d H:i:s', current_time('timestamp'));
		wra_add_report('GetGoldPrice', $insertTime, $url,'', json_encode($result), $result ? 200 : 0,0,'دریافت قیمت طلا از تابان گوهر نفیس');

        if($result && isset($result->YekGram18))
		{
			update_option('wra_gold_api_list', json_encode($result));
			return $result->YekGram18;
		}
            
        return 0;
    }
    


    public function get($path='', $data = null, $method = 'GET', $Bearer = '')
	{
	    
		$url = $this->URL . get_option('wra_gold_web_service_password') . '/' . get_option('wra_gold_web_service_username');

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

		curl_setopt($ch, CURLOPT_VERBOSE, 0);


		curl_setopt($ch, CURLOPT_TIMEOUT, 5000);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

      

        if($Bearer) 
        {
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                "Authorization: Bearer $Bearer",
                "Accept: application/json"
            ]);
        }




		if ($data) {
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
		}

		if ($method == 'POST')
			curl_setopt($ch, CURLOPT_POST, 1);
		else
			curl_setopt($ch, CURLOPT_POST, 0);

		$response = curl_exec($ch);

		global $wra_http_status;
		$wra_http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);




		return $response;

	}



}