<?php

class zarbahaApi
{
    private $URL = 'https://web.zarbaha-co.ir/api/'; 

    public function get_price()
    {
       //if(!get_option('wra_zarbaha_bearer'))
        $this->auth();

        if($bearer = get_option('wra_zarbaha_bearer'))
        {
            $result = json_decode(json_decode($this->get('Price_V2', '', 'GET', $bearer)));


            $url = $this->URL . 'Price_V2';
            $insertTime = date('Y-m-d H:i:s', current_time('timestamp'));
            wra_add_report('GetGoldPrice', $insertTime, $url,'', json_encode($result), ($result && isset($result->status->code) ? $result->status->code : 0),0,'دریافت قیمت طلا از زر بها');
    


            if($result && isset($result->status->code) && $result->status->code==1)
            {
                update_option('wra_gold_api_list', json_encode($result->data));
                return $result->data->Geram18;
            }

        }
        return 0;
    }
    
    public function auth()
    {
        $data = [
            "UserName" => get_option('wra_gold_web_service_username'), 
            "Password" => get_option('wra_gold_web_service_password'), 
        ];

        $result = json_decode($this->get('authentication', json_encode($data), 'POST'));
    



        if($result && isset($result->StatusCode) && $result->StatusCode==200)
        {
            if( isset($result->Value) && $result->Value)
            {
                update_option('wra_zarbaha_bearer', $result->Value);
            }
        }
    }





    public function get($path, $data = null, $method = 'GET', $Bearer = '')
	{
	    
		$url = $this->URL . $path;

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

		curl_setopt($ch, CURLOPT_VERBOSE, 0);


		curl_setopt($ch, CURLOPT_TIMEOUT, 5000);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);



        

        if($Bearer) 
        {
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                "Authorization: Bearer $Bearer",
                "Accept: application/json"
            ]);
        }




		if ($data) {
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
		}

		if ($method == 'POST')
			curl_setopt($ch, CURLOPT_POST, 1);
		else
			curl_setopt($ch, CURLOPT_POST, 0);

		$response = curl_exec($ch);

		global $wra_http_status;
		$wra_http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);




		return $response;

	}



}