<?php
/////////////////////////add to cart///////////////////////////////////



//products page
function wra_validate_add_cart_item($passed, $product_id, $quantity, $variation_id = '', $variations = '')
{
	
	global $woocommerce;
	if(!$product_id)
	{
		if(isset($_GET['elementor_page_id'])) $product_id=$_GET['elementor_page_id'];
		elseif(isset($_POST['add-to-cart'])) $product_id = $_POST['add-to-cart'];
	}	

	$product_quantity = wra_get_product_count($product_id);
	if($product_quantity!=-1)
	{
		$run = new Wra_Product_class;
		$run->update_product_stock($product_id, $product_quantity);			
	}
	return true;
}

 function wra_filter_woocommerce_update_cart_action_cart_updated( $cart_updated ) {
	
    global $woocommerce;
    $cart_items = $woocommerce->cart->get_cart();   
    //iterate thru all cart items
    foreach($cart_items as $cart_item) {

		$product_id= $cart_item['product_id'];

		$run = new Wra_Product_class;
		$product = $run->get_product($product_id);
		$product_quantity = $product->stock_quantity;

		$api_product_quantity = wra_get_product_count($product_id);
	
		if($api_product_quantity!=-1 && $product_quantity>$api_product_quantity)
		{
			WC()->cart->set_quantity( $cart_item['key'], $api_product_quantity );
			$cart_updated = false;

		}

		if ($api_product_quantity!=-1)
		{
			$run->update_product_stock($product_id, $api_product_quantity);
		}

    }

    if ( $cart_updated == false ) {
		wc_add_notice( __( '<div> متاسفانه تعداد موجودی محصول از تعداد مورد نیاز شما کمتر است و از این محصول برای سفارش در انبار موجود است. بابت مشکل پیش آمده پوزش میخواهیم.	   </div>', 'woocommerce' ), 'error' );
    
	
	}

    return $cart_updated;
}


function wra_my_custom_checkout_field_process() {
	$cart_updated =true;
	global $woocommerce;
    $cart_items = WC()->cart->get_cart();   
    //iterate thru all cart items
    foreach($cart_items as $cart_item) {

		$product_id= $cart_item['product_id'];
		$run = new Wra_Product_class;
		$product = $run->get_product($product_id);
		$product_quantity = $product->stock_quantity;

		$api_product_quantity = wra_get_product_count($product_id);

		if($api_product_quantity!=-1 && $product_quantity>$api_product_quantity)
		{
			//WC()->cart->set_quantity( $cart_item['key'], $api_product_quantity );
			$cart_updated = false;
		}

		if ($api_product_quantity!=-1)
			$run->update_product_stock($product_id, $api_product_quantity);

    }
    if ( $cart_updated == false ) {
		wc_add_notice( __( '<div> متاسفانه تعداد موجودی محصول از تعداد مورد نیاز شما کمتر است و از این محصول برای سفارش در انبار موجود است. بابت مشکل پیش آمده پوزش میخواهیم.	   </div>', 'woocommerce' ), 'error' );

	
	}
 
	 return $cart_updated;

}

function wra_run_mailchimp_query()
{

	if(isset($_GET['add-to-cart']) || (isset($_GET['wc-ajax']) && $_GET['wc-ajax']=='add_to_cart'))
	{
		wra_my_custom_checkout_field_process();
	}	
}





function wra_save_field_to_cart($product_id, $quantity) {

	$product = wc_get_product($product_id);
	if($product)
	{
		$quantity = get_product_quantity_in_cart($product_id);

		$gold_price = wra_gold_price();
		$wra_calculate_price_datails = wra_calculate_price_datails($product_id, $gold_price, $quantity);

		$cart_item_data = [];
		//عیار طلا
		$cart_item_data['goldItem']["ProductCutie"] = get_post_meta($product_id, 'ProductCutie', true);
		//مجموع وزن طلا
		$cart_item_data['goldItem']["Weight"] = intval(get_post_meta($product_id, '_weight', true)) * intval($quantity);
		//وزن هر عدد
		$cart_item_data['goldItem']["OneWeight"] = get_post_meta($product_id, '_weight', true);
		//تعداد طلا
		$cart_item_data['goldItem']["Count"] = intval($quantity);
		//مبلغ واحد
		$cart_item_data['goldItem']["UnitPrice"] = wra_gold_price();
		//نوع اجرت ریالی (وزنی / تعدادی)
		$cart_item_data['goldItem']["WageKind"] = get_post_meta($product_id, 'ProductSaleFeeType', true);
		//مبلغ اجرت ریالی
		$cart_item_data['goldItem']["WageMoney"] = get_post_meta($product_id, 'ProductSaleFeeValue', true);
		//درصد اجرت درصدی
		$cart_item_data['goldItem']["PercentWage"] = get_post_meta($product_id, 'ProductSaleFeePercent', true);
		//گرم اجرت درصدی به عیار مرجع
		$cart_item_data['goldItem']["PercentWageRefWeight"] = $wra_calculate_price_datails['PercentWageRefWeight'];
		//مبلغ اجرت درصدی 	
		$cart_item_data['goldItem']["PercentWageMoney"] = $wra_calculate_price_datails['PercentWageMoney'];
		//تعداد سنگ ها
		$cart_item_data['goldItem']["StoneCount"] = get_post_meta($product_id, 'ProductRockCount', true);
		//وزن سنگ ها
		$cart_item_data['goldItem']["StoneWeight"] = get_post_meta($product_id, 'ProductRockWeight', true);
		//قیمت سنگ ها
		$cart_item_data['goldItem']["StonePrice"] = intval(get_post_meta($product_id, 'ProductRockRialCost', true)) * intval($quantity);
		//جمع اجرت ها
		$cart_item_data['goldItem']["SumWageItem"] = $wra_calculate_price_datails['SumWage'];
		//مبلغ خالص
		$cart_item_data['goldItem']["PurePrice"] = $wra_calculate_price_datails['PurePrice'];
		//مبلغ اضافات
		$cart_item_data['goldItem']["Addition"] = $wra_calculate_price_datails['Addition'];
		//مبلغ خالص + سود
		$cart_item_data['goldItem']["GoldPriceWageProfit"] = $wra_calculate_price_datails['GoldPrice_Wage_Profit'];
		//مبلغ نهایی 
		$cart_item_data['goldItem']["TotalPrice"] = $wra_calculate_price_datails['TotalPrice'];
		//نوع سود
		$cart_item_data['goldItem']["ProfitKind"] = get_post_meta($product_id, 'ProductProfitKind', true);
		//درصد سود
		$cart_item_data['goldItem']["ProfitPercent"] =$wra_calculate_price_datails['ProfitPercent'];	
		//مبلغ سود
		$cart_item_data['goldItem']["ProfitMoney"] =$wra_calculate_price_datails['ProfitMoney'];		
		//مبلغ سود
		$cart_item_data['goldItem']["Profit"] =$wra_calculate_price_datails['Profit'];					
		//آیا معاف از مالیات است؟
		$cart_item_data['goldItem']["TaxTollExempt"] = get_post_meta($product_id, 'ProductExemptOnSale', true);
		//درصد مالیات
		$cart_item_data['goldItem']["TaxPercent"] = get_post_meta($product_id, 'ProductTax', true);
		//مبلغ مالیات 
		$cart_item_data['goldItem']["TaxMoney"] = $wra_calculate_price_datails['TaxMoney'];
		//نحوه محاسبه مالیات
		$cart_item_data['goldItem']["CalcTaxTollType"] = get_post_meta($product_id, 'ProductCalcTaxTollType', true);
		//عیار مرجع
		$cart_item_data['goldItem']["RefCutie"] = get_option('ReferenceCutie') ? get_option('ReferenceCutie') : 750;
		//وزن به عیار مرجع
		$cart_item_data['goldItem']["RefWeight"] = $wra_calculate_price_datails['RefWeight'];
		//مبلغ واحد به عیار مرجع
		$cart_item_data['goldItem']["RefUnitPrice"] = $wra_calculate_price_datails['NewPrice'];
		//روش محاسبه قیمت
		$cart_item_data['goldItem']["PriceCalcType"] = 1;
		//نوع تخفیف
		$cart_item_data['goldItem']["DiscountKind"] = get_post_meta($product_id, 'DiscountType', true);
		//مقدار تخفیف
		$cart_item_data['goldItem']["DiscountPercent"] = $wra_calculate_price_datails['DiscountPercent'];
		//مبلغ تخفیف 
		$cart_item_data['goldItem']["DiscountMoney"] = $wra_calculate_price_datails['DiscountMoney'];
		//ارزش ریالی چرم
		$cart_item_data['goldItem']["LeatherPrice"] = intval(get_post_meta($product_id, 'ProductLeatherRialCost', true)) * intval($quantity);
		//ارزش ریالی نقره
		$cart_item_data['goldItem']["SilverPrice"] = intval(get_post_meta($product_id, 'ProductSilverRialCost', true)) * intval($quantity);
		
		
	}
    
	//  print_r($cart_item_data);die;

    return $cart_item_data;
}





function wra_save_custom_field_to_cart($cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data) {

	$product = wc_get_product($product_id);
	if($product)
	{
		$quantity = get_product_quantity_in_cart($product_id);

		$gold_price = wra_gold_price();
		$wra_calculate_price_datails = wra_calculate_price_datails($product_id, $gold_price, $quantity);



		// $SumWeight = get_post_meta($product_id, '_weight', true) * floatval($quantity);
		// $itemsCount = intval($quantity);
		// $SumStoneWeight = get_post_meta($product_id, 'ProductRockWeight', true);
		// $SumStonePrice = get_post_meta($product_id, 'ProductRockRialCost', true);
		// $SumTax = $wra_calculate_price_datails['TaxMoney'];
		// $SumRowDiscount = $wra_calculate_price_datails['DiscountMoney'];
		// $SumRefWeight = $wra_calculate_price_datails['RefWeight'];
		// $SumPurePrice = $wra_calculate_price_datails['PurePrice'];
		// $SumAddition = $wra_calculate_price_datails['Addition'];
		// $SumProfitMoney = $wra_calculate_price_datails['ProfitMoney'];
		// $SumGoldPriceWageProfit = $wra_calculate_price_datails['GoldPrice_Wage_Profit'];
		// $SumWage = get_post_meta($product_id, 'ProductSaleFeeValue', true);
		// $SumTotalPrice = $wra_calculate_price_datails['TotalPrice'];		
		// $SumLeatherPrice = get_post_meta($product_id, 'ProductLeatherRialCost', true);
		// $SumSilverPrice = get_post_meta($product_id, 'ProductSilverRialCost', true);
		// $SumPercentWagePrice = $wra_calculate_price_datails['PercentWageMoney'];
		// $SumPercentWageRefWeight = $wra_calculate_price_datails['PercentWageRefWeight'];




		//عیار طلا
		$cart_item_data['goldItem']["ProductCutie"] = get_post_meta($product_id, 'ProductCutie', true);
		//مجموع وزن طلا
		$cart_item_data['goldItem']["Weight"] = get_post_meta($product_id, '_weight', true) * intval($quantity);
		//وزن هر عدد
		$cart_item_data['goldItem']["OneWeight"] = get_post_meta($product_id, '_weight', true);
		//تعداد طلا
		$cart_item_data['goldItem']["Count"] = intval($quantity);
		//مبلغ واحد
		$cart_item_data['goldItem']["UnitPrice"] = wra_gold_price();
		//نوع اجرت ریالی (وزنی / تعدادی)
		$cart_item_data['goldItem']["WageKind"] = get_post_meta($product_id, 'ProductSaleFeeType', true);
		//مبلغ اجرت ریالی
		$cart_item_data['goldItem']["WageMoney"] = get_post_meta($product_id, 'ProductSaleFeeValue', true);
		//درصد اجرت درصدی
		$cart_item_data['goldItem']["PercentWage"] = get_post_meta($product_id, 'ProductSaleFeePercent', true);
		//گرم اجرت درصدی به عیار مرجع
		$cart_item_data['goldItem']["PercentWageRefWeight"] = $wra_calculate_price_datails['PercentWageRefWeight'];
		//مبلغ اجرت درصدی 	
		$cart_item_data['goldItem']["PercentWageMoney"] = $wra_calculate_price_datails['PercentWageMoney'];
		//تعداد سنگ ها
		$cart_item_data['goldItem']["StoneCount"] = get_post_meta($product_id, 'ProductRockCount', true);
		//وزن سنگ ها
		$cart_item_data['goldItem']["StoneWeight"] = get_post_meta($product_id, 'ProductRockWeight', true);
		//قیمت سنگ ها
		$cart_item_data['goldItem']["StonePrice"] = get_post_meta($product_id, 'ProductRockRialCost', true);
		//جمع اجرت ها
		$cart_item_data['goldItem']["SumWageItem"] = $wra_calculate_price_datails['SumWage'];
		//مبلغ خالص
		$cart_item_data['goldItem']["PurePrice"] = $wra_calculate_price_datails['PurePrice'];
		//مبلغ اضافات
		$cart_item_data['goldItem']["Addition"] = $wra_calculate_price_datails['Addition'];
		//مبلغ خالص + سود
		$cart_item_data['goldItem']["GoldPriceWageProfit"] = $wra_calculate_price_datails['GoldPrice_Wage_Profit'];
		//مبلغ نهایی 
		$cart_item_data['goldItem']["TotalPrice"] = $wra_calculate_price_datails['TotalPrice'];
		//نوع سود
		$cart_item_data['goldItem']["ProfitKind"] = get_post_meta($product_id, 'ProductProfitKind', true);
		//مبلغ سود
		$cart_item_data['goldItem']["ProfitMoney"] =$wra_calculate_price_datails['Profit'];						
		//آیا معاف از مالیات است؟
		$cart_item_data['goldItem']["TaxTollExempt"] = get_post_meta($product_id, 'ProductExemptOnSale', true);
		//درصد مالیات
		$cart_item_data['goldItem']["TaxPercent"] = get_post_meta($product_id, 'ProductTax', true);
		//مبلغ مالیات 
		$cart_item_data['goldItem']["TaxMoney"] = $wra_calculate_price_datails['TaxMoney'];
		//نحوه محاسبه مالیات
		$cart_item_data['goldItem']["CalcTaxTollType"] = get_post_meta($product_id, 'ProductCalcTaxTollType', true);
		//عیار مرجع
		$cart_item_data['goldItem']["RefCutie"] = get_option('ReferenceCutie') ? get_option('ReferenceCutie') : 750;
		//وزن به عیار مرجع
		$cart_item_data['goldItem']["RefWeight"] = $wra_calculate_price_datails['RefWeight'];
		//مبلغ واحد به عیار مرجع
		$cart_item_data['goldItem']["RefUnitPrice"] = $wra_calculate_price_datails['NewPrice'];
		//روش محاسبه قیمت
		$cart_item_data['goldItem']["PriceCalcType"] = 1;
		//نوع تخفیف
		$cart_item_data['goldItem']["DiscountKind"] = get_post_meta($product_id, 'DiscountType', true);
		//مقدار تخفیف
		$cart_item_data['goldItem']["DiscountPercent"] = $wra_calculate_price_datails['DiscountPercent'];
		//مبلغ تخفیف 
		$cart_item_data['goldItem']["DiscountMoney"] = $wra_calculate_price_datails['DiscountMoney'];
		//ارزش ریالی چرم
		$cart_item_data['goldItem']["LeatherPrice"] = get_post_meta($product_id, 'ProductLeatherRialCost', true);
		//ارزش ریالی نقره
		$cart_item_data['goldItem']["SilverPrice"] = get_post_meta($product_id, 'ProductSilverRialCost', true);
		
		
	}
    
	//  print_r($cart_item_data);die;

    return $cart_item_data;
}




function get_product_quantity_in_cart($product_id, $variation_id = 0) {
    $quantity = 0;

    foreach (WC()->cart->get_cart() as $item) {
        if ($item['product_id'] == $product_id) {
            if ($variation_id) {
                if ($item['variation_id'] == $variation_id) {
                    $quantity += $item['quantity'];
                }
            } else {
                $quantity += $item['quantity'];
            }
        }
    }

    return $quantity;
}



function wra_transfer_custom_field_to_order($item_id, $values, $cart_item_key) {
    if (isset($values['goldItem'])) wc_add_order_item_meta($item_id, 'goldItem', $values['goldItem']);
}





if (get_option('wra_state') == 'on' && get_option('wra_get_stock') == 'on')
{
	add_filter('woocommerce_add_to_cart', 'wra_validate_add_cart_item', 10, 5);
	add_filter('woocommerce_add_to_cart_validation', 'wra_validate_add_cart_item', 10, 5);
	add_filter( 'woocommerce_update_cart_action_cart_updated', 'wra_filter_woocommerce_update_cart_action_cart_updated', 10, 1 );
	add_action('woocommerce_checkout_process', 'wra_my_custom_checkout_field_process');
	add_action( 'init', 'wra_run_mailchimp_query');

	// add_filter('woocommerce_add_cart_item_data', 'wra_save_custom_field_to_cart2', 10, 2);
	//add_action('woocommerce_add_to_cart', 'wra_save_custom_field_to_cart', 20, 6);



	add_action('woocommerce_add_order_item_meta', 'wra_transfer_custom_field_to_order', 10, 3);
}






add_action('before_delete_post', function($id) {
    $post_type = get_post_type($id);
    if ($post_type === 'shop_order') {
		wra_delete_queue($id);
        return;
    }

   // $order = new WC_Order($id);
    //do some stuff with order meta data
}, 10, 1);






