<?php
//add setting page to menu

if (!class_exists('WP_List_Table')) {
	require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}



function wra_rest_api_groups_page_content()
{
	if (isset($_POST['assign-group-submit']) && isset($_POST['group'])) {
		global $wpdb;
		$table = $wpdb->base_prefix . 'wra_groups';

		foreach ($_POST['group'] as $key => $group) {
			$sql = "UPDATE {$table} set siteGroupId={$group} WHERE id=" . $key;
			$wpdb->query($sql);
		}
		wra_notice('تغییرات با موفقیت ذخیره شد.', 'success');
	}

	if(isset($_GET['delete_all_groups']))
	{
		global $wpdb;
		$table = $wpdb->base_prefix . 'wra_groups';
		$sql = "DELETE FROM {$table}";
		$wpdb->query($sql);		
		header('Location: ?page=rest_api_groups&show_api_buttons');
	}

	if(isset($_GET['delete_group']) && isset($_GET['id']))
	{
		global $wpdb;
		$table = $wpdb->base_prefix . 'wra_groups';
		$sql = "DELETE FROM {$table} where id=".$_GET['id'];
		$wpdb->query($sql);
		header('Location: ?page=rest_api_groups&show_api_buttons');
		
	}

	
?>
	<link rel='stylesheet' href='<?php echo plugin_dir_url(__FILE__) ?>../assets/style.css'>
<div class="wrap wra-page">	
	<h1>انتساب گروه ها</h1>
		<?php
			$wp_list_table = new Wra_Group_List_Table();
			$wp_list_table->prepare_items();
			$wp_list_table->display();
        ?>
	</form>
</div>

<?php
}


class Wra_Group_List_Table extends WP_List_Table
{
	public function __construct()
	{
		parent::__construct(
			array(
				'singular' => 'test',
				'plural' => 'tests',
				'ajax' => false
			)
		);
	}

	function extra_tablenav($which)
	{
		if ($which == "top") {
			
			$date = new jalaliDate();

			$group_name = '';
			if (isset($_GET['group_name']) && $_GET['group_name'])
				$group_name = $_GET['group_name'];
			$parent_group = '';
			if (isset($_GET['parent_group']) && $_GET['parent_group'])
				$parent_group =$_GET['parent_group'];
			$selected_group = '';				
			if (isset($_GET['selected_group']) && $_GET['selected_group'])
				$selected_group =$_GET['selected_group'];				

			echo '
				<form class="wra-form" method="get">
					<div class="wra-row">
						<input type="hidden" name="page" value="rest_api_groups">				
						<div class="wra-col"><label>نام گروه</label><input name="group_name" value="'.$group_name.'" autocomplete="off"></div>
						<div class="wra-col"><label>دسته بندی گروه</label><input name="parent_group" class="" value="' . $parent_group . '" autocomplete="off"></div>
						<div class="wra-col"><label>نام گروه انتساب داده شده </label><input name="selected_group" value="'.$selected_group.'" autocomplete="off"></div>
						<div class="wra-col" style="direction: ltr;"><button class="button button-primary">جستجو</button></div>
					</div>
				</form>	';
			if(isset($_GET['show_api_buttons']))
			{
				echo '<div style="float: right;padding-bottom: 10px;">
						<a href="?page=rest_api_groups&show_api_buttons&delete_all_groups" class="button">حذف همه گروه ها</a>	 			 
					</div>
					
				';
			}
			echo '<form method="post"> ';


		}
		if ($which == "bottom") {
			echo "<button type='submit' name='assign-group-submit' class='button button-primary'>ذخیره تغییرات</button>";
		}
	}

	function get_columns()
	{
		$columns = array(
			'title' => 'نام گروه در نرم افزار',
			'groupParentID' => 'دسته بندی در نرم افزار',
			'siteGroupId' => 'انتساب (دسته‌های ووکامرس)',
			'report' => 'گزارشات',
		);
		if(isset($_GET['show_api_buttons']))$columns['tools']='';
		return $columns;
	}

	function get_sortable_columns()
	{
		return $sortable = array(
			'id' => array('id', false),
			'title' => array('title', false),
		);
	}


	function column_default($item, $column_name)
	{

		$args = array(
			'taxonomy' => "product_cat",
			'hide_empty' => 0,
		);
		$product_categories = get_terms($args);
		//echo json_encode($product_categories);die;

		global $wpdb;
		$query = "SELECT * FROM {$wpdb->base_prefix}wra_groups";
		$product_categories_list = $wpdb->get_results($query);

		$parent = '---';
		if ($column_name == 'groupParentID' && $product_categories_list)
			foreach ($product_categories_list as $category)
				if ($category->group_id == $item[$column_name]) {
					$parent = $category->title;
				}

		$select_data = '';

		if ($column_name == 'siteGroupId' && $product_categories)
		{
			$select_data = $this->get_groups($product_categories, $item , 0);
			// foreach ($product_categories as $category) {

			        
    		// 		if ($category->term_id == $item['siteGroupId'])
    		// 			$select_data .= "<option value='" . $category->term_id . "' selected>" . $category->name . "</option>";
			// 		elseif(!$item[$column_name] && wra_fix_letter($category->name)==wra_fix_letter($item['title']))
			// 			$select_data .= "<option value='" . $category->term_id . "' selected>" . $category->name . "</option>";    				
			// 		else
    		// 			$select_data .= "<option value='" . $category->term_id . "'>" . $category->name . "</option>";
			
    					
			// }
		}
	


		switch ($column_name) {
			case 'id':
			case 'title':
				return $item[$column_name];
			case 'groupParentID':
				return $parent;
			case 'siteGroupId':
				return "<select name='group[" . $item['id'] . "]' class='form-control'>" . $select_data . "</select>";
			case 'tools':				
				return '<a href="?page=rest_api_groups&show_api_buttons&delete_group&id='.$item['id'].'" class="button">حذف  گروه </a>';
			case 'report':
				return "<a href='?page=rest_api_reports&g=".$item['group_id']."'>مشاهده</a>"; 
			default:
				return print_r($item, true);
		}
	}

	function get_groups(&$groups_list, &$item , $parent, $step=0)
	{ 
		$select_data = '';
		$step_space = str_repeat('&nbsp;&nbsp;&nbsp;', $step);
		if($groups_list)
			foreach($groups_list as $category)
			{
				if($category->parent==$parent)
				{
					
    				if ($category->term_id == $item['siteGroupId'])
    					$select_data .= "<option value='" . $category->term_id . "' selected>" . $step_space . $category->name . "</option>";
					elseif(!$item['siteGroupId'] && wra_fix_letter($category->name)==wra_fix_letter($item['title']))
						$select_data .= "<option value='" . $category->term_id . "' selected>" . $step_space . $category->name . "</option>";    				
					elseif(!$item['siteGroupId']) 
						$select_data .= "<option value='" . $category->term_id . "' selected>" . $step_space . $category->name . "</option>";    				
					else
    					$select_data .= "<option value='" . $category->term_id . "'>" . $step_space . $category->name . "</option>";

					$select_data .= $this->get_groups($groups_list, $item , $category->term_id, $step+1);

				}
			}

			return $select_data;
	}

 
	function prepare_items()
	{
		global $wpdb;
		$query = "SELECT g.* FROM {$wpdb->base_prefix}wra_groups as g 
					left join {$wpdb->base_prefix}wra_groups as gp on gp.group_id =g.groupParentID 
					left join {$wpdb->base_prefix}terms as t on t.term_id =g.siteGroupId 
					WHERE g.title not like 'گـروه كالا'";


  
		if (isset($_GET['group_name']) && $_GET['group_name'])
		{ 
			$group_name = str_replace('ی','ي',$_GET['group_name']);
			$group_name = str_replace('ک','ك',$group_name);
			$group_name2 = str_replace('ي','ی',$_GET['group_name']);
			$group_name2 = str_replace('ك','ک',$group_name2);
			$query .= ' and (g.title like "%'.$group_name.'%" or g.title like "%'.$group_name2.'%") ';
			
		}


		if (isset($_GET['parent_group']) && $_GET['parent_group'])
		{
			$parent_group = str_replace('ی','ي',$_GET['parent_group']);
			$parent_group = str_replace('ک','ك',$parent_group);
			$parent_group2 = str_replace('ي','ی',$_GET['parent_group']);
			$parent_group2 = str_replace('ك','ک',$parent_group2);
			$query .= ' and (gp.title like "%'.$parent_group.'%" or gp.title like "%'.$parent_group2.'%") ';
		}

		if (isset($_GET['selected_group']) && $_GET['selected_group'])
		{			
			$selected_group = str_replace('ی','ي',$_GET['selected_group']);
			$selected_group = str_replace('ک','ك',$selected_group);
			$selected_group2 = str_replace('ي','ی',$_GET['selected_group']);
			$selected_group2 = str_replace('ك','ک',$selected_group2);
			$query .= ' and t.name like "%'.$_GET['selected_group'].'%" ';
			$query .= ' and (t.name like "%'.$selected_group.'%" or t.name like "%'.$selected_group2.'%") ';
		}



		$orderby = !empty($_GET["orderby"]) ? $_GET["orderby"] : 'ASC';
		$order = !empty($_GET["order"]) ? $_GET["order"] : '';
		if (!empty($orderby) & !empty($order)) {
			$query .= ' ORDER BY g.' . $orderby . ' ' . $order;
		}
		$totalitems = $wpdb->query($query);
		$perpage = 20;
		$paged = !empty($_GET["paged"]) ? intval($_GET["paged"]) : '';
		if (empty($paged) || !is_numeric($paged) || $paged <= 0) {
			$paged = 1;
		}
		$totalpages = ceil($totalitems / $perpage);
		if (!empty($paged) && !empty($perpage)) {
			$offset = ($paged - 1) * $perpage;
			$query .= ' LIMIT ' . (int) $offset . ',' . (int) $perpage;
		}
		$this->set_pagination_args(
			array(
				"total_items" => $totalitems,
				"total_pages" => $totalpages,
				"per_page" => $perpage,
			)
		);
		$columns = $this->get_columns();
		$hidden = array();
		$sortable = $this->get_sortable_columns();
		$this->_column_headers = array($columns, $hidden, $sortable);
		$items = $wpdb->get_results($query);
		if ($items)
			foreach ($items as &$item)
				$item = (array) $item;
		$this->items = (array) $items;
	}
}