<?php
//add setting page to menu

/////////////////////////////////////////////////////////////
// انتساب خودکار کالاها
if(isset($_GET['assign-product']))
{
	global $wpdb;
	$table = $wpdb->base_prefix . 'wra_products_map';

	// دریافت لیست تمام محصولات ووکامرس
	$products = $wpdb->get_results("
		SELECT p.ID AS product_id, pm.meta_value AS product_code 
		FROM {$wpdb->prefix}posts p
		JOIN {$wpdb->prefix}postmeta pm ON p.ID = pm.post_id
		WHERE p.post_type = 'product' 
		AND p.post_status = 'publish'
		AND pm.meta_key = '_sku'
	");
	if($products)
	foreach ($products as $product) {
		$product_id = $product->product_id;
		$product_code = $product->product_code;
	
		$exists = $wpdb->get_var($wpdb->prepare("
			SELECT count(*) FROM {$table} WHERE productId = %d
		", $product_id));
	
		$productCode = $wpdb->get_var($wpdb->prepare("
			SELECT productCode FROM {$table} WHERE productId = %d
		", $product_id));


		if ($exists == 0) {
			$wpdb->insert(
				$table,
				[
					'productId' => $product_id,
					'productCode' => $product_code,
					'apiProductId' => 0, 
					'ProductCnuId' => 0 
				],
				['%d', '%s', '%d', '%d']
			);
		}
		else if(!$productCode)
		{
			$wpdb->update(
				$table,
				[
					'productCode' => $product_code,
				],
				[
					'productId' => $product_id, 
				]
			);
		}



	}


}

//////////////////////////////////////////////////////////////
// حذف کالا از جدول products_map بعد از حذف کالا
add_action( 'delete_post', 'notification_for_product', 99 );
function notification_for_product( $post_id ){
	global $wpdb;
	$table = $wpdb->base_prefix . 'wra_products_map';
	$sql = "DELETE FROM {$table} where productId={$post_id}";
	$wpdb->query($sql);		
}
 

///////////////////////////////////////////////////////////////
// افزودن ستون منبع به لیست محصولات
add_filter( 'manage_edit-product_columns', 'wra_add_column_to_product',1 );
function wra_add_column_to_product($columns){
   $columns['product_api_type'] ='منبع'; 
   return array_slice( $columns, 0, 8, true ) + array( 'product_api_type' => 'منبع' ) + array_slice( $columns, 8, count( $columns ) - 8, true );
}
// افزون مرتب سازی به ستون
add_filter( 'manage_edit-product_sortable_columns', 'wra_column_sortable' );
function wra_column_sortable( $columns){
   $columns['product_api_type'] = 'product_api_type';
   return $columns;
}

add_action( 'pre_get_posts', 'bbloomer_onsale_product_sort' );
function bbloomer_onsale_product_sort( $query ) {
    if ( ! is_admin() ) return; 
    $orderby = $query->get( 'orderby');
    if ( 'product_api_type' == $orderby ) {
		$query->set( 'meta_key', 'product_api_type' );
        $query->set( 'orderby', 'meta_value_num' );
    }
}

// نمایش مقدار ستون
add_action( 'manage_product_posts_custom_column' , 'wra_column_value', 10, 2 );
function wra_column_value( $column, $post_id ) {
	if($column == 'product_api_type')
	{
		$product_api_type=get_post_meta($post_id, 'product_api_type');
		if($product_api_type && is_array($product_api_type) && $product_api_type[0]==1)
		{
			echo 'وب Api'; 
			if(get_option('wra_save_action_logs')=='on')
				echo '<div><a href="admin.php?page=rest_api_reports&productId='.$post_id.'" style="color: red;">گزارش همگام سازی</a></div>';
		}
		else
		{
			echo 'وردپرس';
		}
	}
}
///////////////////////////////////////////////////////////////

if (!class_exists('WP_List_Table')) {
	require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}



// if(isset($_GET['page']) && $_GET['page'] == 'rest_api_products' && isset($_GET['update_rows']))
// {
// 	global $wpdb;
// 	$table = $wpdb->base_prefix . 'wra_reports';
// 	$query = "select response from {$table} where  action like 'GetProducts'";
// 	$product_items = $wpdb->get_results($query);

// 	if($product_items)
// 	foreach($product_items as $item)
// 	{
// 		$data = json_decode($item->response);
// 		if($data)
// 		foreach($data->products as $product)
// 		{
// 			$table = $wpdb->base_prefix . 'wra_products_map';
// 			$query = "select * from {$table} where  apiProductId = ".$product->productID;
// 			$product_map = $wpdb->get_results($query);
			
// 			echo $product_map[0]->productCode.'<br>';
// 			if($product_map && $product_map[0]->productCode=='')
// 			{
				
// 				$sql = "UPDATE {$table} set productCode={$product->productCode} WHERE apiProductId=" . $product->productID;
// 				echo 	$sq
// 				$wpdb->query($sql);				
// 			}
// 		}
// 	}
// 	die;
// }


	if (isset($_POST['wra_assign-product-submit']) && isset($_POST['wra_product'])) {
	    
	
		global $wpdb;
		$table = $wpdb->base_prefix . 'wra_products_map';
		$wra_error=false;
		// بررسی شناسه کالای تکراری
		$ids=[];
		foreach ($_POST['wra_product'] as $key1 => $product1) {
			$ids[]=$key1;
		    foreach ($_POST['wra_product'] as $key2 => $product2) {
				//$query = "select productCode from {$table} where productId != {$key} and productCode={$product}";
				//$product_item = $wpdb->query($query);
		    
				if($key1 != $key2 && $product1 == $product2 && $product1)
				{
					$wra_error = 'شناسه کالای '.$product1.' تکراری است.';
					
					break;
				}
		    }
		}
		// بررسی تکراری بودن شناسه کالا در دیتابیس
		foreach ($_POST['wra_product'] as $key => $product) 
			if($product)
			{
				
				$query = "select productCode from {$table} where productId != {$key} and productCode='{$product}' and productId not in (".implode(',',$ids).")";
				$product_item = $wpdb->query($query);
				
				if($product_item)
				{
					$wra_error = 'شناسه کالای '.$product1.' تکراری است.';
					break;
				}
			}

		if(!$wra_error)
		{
    		foreach ($_POST['wra_product'] as $key => $product) {
       			if ($wpdb->query("SELECT * FROM {$table} WHERE productId=" . $key)) {
     				$sql = "UPDATE {$table} set productCode='{$product}' WHERE productId=" . $key;

     			} else {
    				$sql = "INSERT INTO {$table} (`productId` , `productCode`, `apiProductId`, `ProductCnuId`) VALUES ({$key},'{$product}',0,0)";
    			}
    
    			$wpdb->query($sql);
    		}
			
    		// حذف ردیف های اضافی
    		$sql = "DELETE FROM {$table} WHERE productCode =''";
        	$wpdb->query($sql);



			//آپدیت meta محصولات
			$query = "SELECT p.ID
						FROM {$wpdb->base_prefix}posts as p 
						where p.post_type='product' and p.post_status = 'publish'";
		
			$produts = $wpdb->get_results($query);
			foreach($produts as $post_array)
			{
				$query = "select productCode from {$table} where productId = {$post_array->ID}";
				$product_item = $wpdb->query($query);

				if($product_item)
				{	
					update_post_meta($post_array->ID, 'product_api_type', 1);
				}
				else
				{
					update_post_meta($post_array->ID, 'product_api_type', 0);
				}
			}



    		
    		wra_notice('تغییرات با موفقیت ذخیره شد.', 'success');
		}
		else
		{
		        wra_notice($wra_error, 'error');
		}
	}



function wra_rest_api_products_page_content()
{

	if(isset($_GET['delete_all_products']))
	{
		global $wpdb;
		$table = $wpdb->base_prefix . 'wra_products_map';
		$sql = "DELETE FROM {$table}";
		$wpdb->query($sql);		
		header('Location: ?page=rest_api_products&show_api_buttons');
	}

	if(isset($_GET['delete_product']) && isset($_GET['id']))
	{
		global $wpdb;
		$table = $wpdb->base_prefix . 'wra_products_map';
		$sql = "DELETE FROM {$table} where id=".$_GET['id'];
		$wpdb->query($sql);
		header('Location: ?page=rest_api_products&show_api_buttons');
		
	}


	?>
	<link rel='stylesheet' href='<?php echo plugin_dir_url(__FILE__) ?>../assets/style.css'>
	<div class="wrap wra-page">
		<h1>انتساب محصولات</h1>
			<?php
			$wp_list_table = new Wra_Product_List_Table();
			$wp_list_table->prepare_items();
			$wp_list_table->display();
			?>
	</div>
	<?php
}


class Wra_Product_List_Table extends WP_List_Table
{
	public function __construct()
	{
		parent::__construct(
			array(
				'singular' => 'test',
				'plural' => 'tests',
				'ajax' => false
			)
		);
	}

	function extra_tablenav($which)
	{
		if ($which == "top") {
			$date = new jalaliDate();
			$status = 0;
			if (isset($_GET['status']) && $_GET['status'] != -1)
				$status = $_GET['status'];

			$productName = '';
			if (isset($_GET['productName']) && $_GET['productName'])
				$productName = $_GET['productName'];
			$code = '';
			if (isset($_GET['code']) && $_GET['code'])
				$code =$_GET['code'];

			echo '
                <p><a href="?page=rest_api_products&assign-product" class="button button-primary">ثبت خودکار شناسه کالا</a></p>
				<form class="wra-form" method="get">
					<div class="wra-row">
						<input type="hidden" name="page" value="rest_api_products">				
						<div class="wra-col"><label>نام کالا</label><input name="productName" value="'.$productName.'" autocomplete="off"></div>
						<div class="wra-col"><label>شناسه کالا</label><input name="code" class="" value="' . $code . '" autocomplete="off"></div>
						<div class="wra-col">
						<label>وضعیت شناسه</label>
						<select style="text-align: right;" name="status">
							<option value="0"></option>	
							<option value="1" ' . (($status == 1) ? "selected" : "") . '>کالاهای بدون شناسه</option>	
							<option value="2" ' . (($status == 2) ? "selected" : "") . '>کالاهای با شناسه</option>	
						</select>
					</div>
						<div class="wra-col" style="direction: ltr;"><button class="button button-primary">جستجو</button></div>
					</div>
				</form>	';	

				if(isset($_GET['show_api_buttons']))
				{
					echo '
						<form method="post">
					';
				}

				echo '<form method="post">	
				<input type="hidden" name="page" value="rest_api_products">
			';



		}
		if ($which == "bottom") {
			echo "<button type='submit' name='wra_assign-product-submit' class='button button-primary'>ذخیره تغییرات</button>";
		}
	}

	function get_columns()
	{
		$columns = array(
			'productTitle' => 'نام کالا در سایت',
			'siteProductId' => 'شناسه کالا در نرم افزار',	
			'report' => 'گزارشات',		
		);

		return $columns;
	}

	function get_sortable_columns()
	{
		return $sortable = array(
			'id' => array('id', false),
			'productTitle' => array('productTitle', false),
		);
	}


	function column_default($item, $column_name)
	{

		$args = array(
			'taxonomy' => "product_cat",
			'hide_empty' => 0,
		);
		$product_categories = get_terms($args);

		global $wpdb;
		$query = "SELECT * FROM {$wpdb->base_prefix}wra_products_map";
		$product_list = $wpdb->get_results($query);

		$select_data = '';

		// if ($column_name == 'siteGroupId' && $product_categories)
		// {
		// 	foreach ($product_categories as $category) {


		// 			if ($category->term_id == $item['siteGroupId'])
		// 				$select_data .= "<option value='" . $category->term_id . "' selected>" . $category->name . "</option>";
		// 			elseif(!$item[$column_name] && wra_fix_letter($category->name)==wra_fix_letter($item['title']))
		// 				$select_data .= "<option value='" . $category->term_id . "' selected>" . $category->name . "</option>";    				
		// 			else
		// 				$select_data .= "<option value='" . $category->term_id . "'>" . $category->name . "</option>";


		// 	}
		// }



		switch ($column_name) {
			case 'id':
			case 'productTitle':
				return $item[$column_name];
			case 'siteProductId':
				return "<input name='wra_product[" . $item['siteProductId'] . "]' class='form-control' value='" . $item['productCode'] . "'>";
			case 'report':
				return "<a href='?page=rest_api_reports&p=".$item['productCode']."'>مشاهده</a>";
			default:
				return print_r($item, true);
		}
	}

	function prepare_items()
	{
		global $wpdb;
		$query = "SELECT pm.productCode,pm.id as id, p.post_title as productTitle, p.ID as siteProductId 
					FROM {$wpdb->base_prefix}posts as p 
					left join {$wpdb->base_prefix}wra_products_map as pm on pm.productId=p.ID 
					where p.post_type='product' and p.post_status = 'publish'";
		

		if (isset($_GET['code']) && $_GET['code'])
		$query .= ' and pm.productCode ="' . $_GET['code'] . '" ';

		if (isset($_GET['status']) && $_GET['status'] == 1)
			$query .= ' and (pm.productCode ="" or pm.productCode is null) '; 

		if (isset($_GET['status']) && $_GET['status'] == 2)
		$query .= ' and pm.productCode !="" ';	
		
		if (isset($_GET['productName']) && $_GET['productName'])
		{
			$productNameType1 = str_replace('ی','ي',$_GET['productName']);
			$productNameType1 = str_replace('ک','ك',$productNameType1);

			$productNameType2 = str_replace('ي','ی',$_GET['productName']);
			$productNameType2 = str_replace('ك','ک',$productNameType2);

			$query .= ' and (p.post_title like "%' . $productNameType1 . '%" or p.post_title like "%' . $productNameType2 . '%") ';			
		}



		//$query = "SELECT id,productId as siteProductId,productCode FROM {$wpdb->base_prefix}wra_products_map";
		$orderby = !empty($_GET["orderby"]) ? $_GET["orderby"] : 'ASC';
		$order = !empty($_GET["order"]) ? $_GET["order"] : '';
		if (!empty($orderby) & !empty($order)) {
			$query .= ' ORDER BY p.post_title ' . $order;
		}
		$totalitems = $wpdb->query($query);
		$perpage = 20;
		$paged = !empty($_GET["paged"]) ? intval($_GET["paged"]) : '';
		if (empty($paged) || !is_numeric($paged) || $paged <= 0) {
			$paged = 1;
		}
		$totalpages = ceil($totalitems / $perpage);
		if (!empty($paged) && !empty($perpage)) {
			$offset = ($paged - 1) * $perpage;
			$query .= ' LIMIT ' . (int) $offset . ',' . (int) $perpage;
		}
		$this->set_pagination_args(
			array(
				"total_items" => $totalitems,
				"total_pages" => $totalpages,
				"per_page" => $perpage,
			)
		);
		$columns = $this->get_columns();
		$hidden = array();
		$sortable = $this->get_sortable_columns();
		$this->_column_headers = array($columns, $hidden, $sortable);
		$produts = $wpdb->get_results($query);

		$items = $produts;
		if ($items)
			foreach ($items as &$item)
				$item = (array) $item;
		$this->items = (array) $items;
	}
}