<?php
if (!class_exists('WP_List_Table')) {
	require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}
if (isset($_GET['action']) && $_GET['action'] == 'reject-queue' && isset($_GET['queue'])) {
	wra_update_state_queue($_GET['queue'], -1);
}
if (isset($_GET['action']) && $_GET['action'] == 'resend-queue' && isset($_GET['queue'])) {

	add_action('woocommerce_init', function () {
		add_action('init', 'wra_resend_queue_request');
	});
}

function wra_resend_queue_request(){
	wra_resend_queue($_GET['queue']);
}



function wra_rest_api_queue_page_content()
{
	?>
	<link rel='stylesheet' href='<?php echo plugin_dir_url(__FILE__) ?>../assets/style.css'>
	<link rel="stylesheet" href="<?php echo plugin_dir_url(__FILE__) ?>../assets/persian-datepicker.css">
	<div class="wrap wra_report  wra-page">
		<h1>گزارش صف ارسال</h1>
		<div class="wra-table-box">
			<?php
			$wp_list_table = new Wra_Queue_List_Table();
			$wp_list_table->prepare_items();
			$wp_list_table->display();
			?>
		</div>
	</div>

	<script src="<?php echo plugin_dir_url(__FILE__) ?>../assets/jquery-3.4.1.js"></script>
	<script src="<?php echo plugin_dir_url(__FILE__) ?>../assets/persian-date.js"> </script>
	<script src="<?php echo plugin_dir_url(__FILE__) ?>../assets/persian-datepicker.js"></script>
	<script>
		$(".wra-date-picker").pDatepicker(
			{
				format: 'YYYY/MM/DD', initialValue: false, initialValueType: 'persian'
			}
		);
	</script>
	<style>.column-data{direction: ltr;}</style>
	<script>
		$('.copy-text').click(function (){
			const textToCopy = $(this).parent().find('.wra-data-view').html();
				navigator.clipboard.writeText(textToCopy)
					.then(() => alert("✅ متن کپی شد!"))
					.catch(err => alert("❌ خطا در کپی متن: " + err));
		

		});

	</script>

	<?php
}


class Wra_Queue_List_Table extends WP_List_Table
{
	public $row_index = 0;
	public $perpage = 20;

	public function __construct()
	{
		$paged = !empty($_GET["paged"]) ? $_GET["paged"] : 1;
		$this->row_index = ($paged - 1) * $this->perpage;

		parent::__construct(
			array(
				'singular' => 'test',
				'plural' => 'tests',
				'ajax' => false
			)
		);
	}

	function extra_tablenav($which)
	{
		if ($which == "top") {
			$date = new jalaliDate();
			$action = '';
			if (isset($_GET['action']) && $_GET['action'])
				$action = $_GET['action'];
			$status = 0;
			if (isset($_GET['status']))
				$status = $_GET['status'];
			$from = '';
			if (isset($_GET['from']) && $_GET['from'])
				$from = $date->getNumberInPersian($_GET['from']);
			$to = '';
			if (isset($_GET['to']) && $_GET['to'])
				$to = $date->getNumberInPersian($_GET['to']);

			echo '
				<form class="wra-form" method="get">
					<div class="wra-row">
						<div class="wra-col">
							<label>وضعیت</label>
							<select style="text-align: right;" name="status">
								<option value="2"></option>	
								<option value="0" ' . (($status == 0) ? "selected" : "") . '>منتظر ارسال</option>	
								<option value="1" ' . (($status == 1) ? "selected" : "") . '>ارسال شده</option>	
								<option value="-1" ' . (($status == -1) ? "selected" : "") . '>لغو شده</option>	
								<option value="-2" ' . (($status == -2) ? "selected" : "") . '>حذف شده (سفارش مورد نظر حذف شده)</option>	
							</select>
						</div>
						<input type="hidden" name="page" value="rest_api_queues">					
						<div class="wra-col"><label>تاریخ شروع</label><input name="from" class="wra-date-picker" value="' . $from . '" autocomplete="off"></div>
						<div class="wra-col"><label>تاریخ پایان</label><input name="to" class="wra-date-picker" value="' . $to . '" autocomplete="off"></div>
						<div class="wra-col" style="direction: ltr;"><button class="button button-primary">جستجو</button></div>
					</div>
				</form>			
			';
		}
		if ($which == "bottom") {
			echo "";
		}
	}

	function get_columns()
	{
		$columns = array(
			'rw' => '#',
			'url' => 'آدرس',
			'method' => 'متد',
			'data' => 'دیتای ارسالی',
			'retry' => 'تعداد تلاش',
			'status' => 'وضعیت',
			'created_at' => 'تاریخ ثبت',
			'send_at' => 'تاریخ ارسال'
		);
		return $columns;
	}

	function get_sortable_columns()
	{
		return $sortable = array(
			'action' => array('method', false),
		);
	}


	function column_default($item, $column_name)
	{
		$date = new jalaliDate();
		switch ($column_name) {
			case 'rw':
				$this->row_index++;
				return $this->row_index;
			case 'url':
			case 'method':
				return $item[$column_name];
			case 'retry':
				$rt = '<a href="?page=rest_api_reports&queue=' . $item['id'] . '">' . $item[$column_name] . ($item[$column_name] ? ' (مشاهده)' : '') . '</a>';
				if ($item['status'] == 0)
				{
					$rt .= '<p><a href="?page=rest_api_queues&action=reject-queue&queue=' . $item['id'] . '" style="color:red;">لغو ارسال</a>';
					$rt .= '<br><a href="?page=rest_api_queues&action=resend-queue&queue=' . $item['id'] . '" style="color:green;">ارسال مجدد</a></p>';
				}
				return $rt;
			case 'data':
			    
				$data_show = ($item[$column_name] && json_decode($item[$column_name]))  ? json_encode(json_decode($item[$column_name]), JSON_PRETTY_PRINT |JSON_UNESCAPED_UNICODE |JSON_UNESCAPED_SLASHES |JSON_HEX_TAG |JSON_HEX_AMP |JSON_HEX_QUOT |JSON_HEX_APOS) : "";
				if ($data_show) { 
					return '<div style="width:100%;height: 150px;direction: ltr;overflow: auto;border: 1px solid gray; position: relative; resize: both;overflow: auto;background-color: white;"><pre class="wra-data-view" style="white-space: break-spaces;font-size: 12px;width: 95%;margin: auto;">' . $data_show . '</pre></div><button class="copy-text button button-primary" style="margin-top: 5px;">کپی</button>';

				} elseif($item[$column_name])
				{
					return '<div style="width:100%;height: 150px;direction: ltr;overflow: auto;border: 1px solid gray; position: relative; resize: both;overflow: auto;background-color: white;">'.nl2br($item[$column_name]).'</div>';
				}
				else
				{
				return '<div style="direction: rtl;">'.nl2br($item[$column_name]).'</div>';
				}

			case 'status':
				if ($item[$column_name] == 1)
					return 'ارسال شده';
				elseif ($item[$column_name] == -1)
					return 'لغو شده';
				elseif ($item[$column_name] == -2)
					return 'حذف شده (سفارش مورد نظر حذف شده)';
				else
					return 'منتظر ارسال';
			case 'created_at':
			case 'send_at':
				if ($item[$column_name] != '0000-00-00 00:00:00')
					return $date->getDate($item[$column_name]);
				else
					return '[...]';
			default:
				return print_r($item, true);
		}
	}

	function prepare_items()
	{
		$status = 0;
		if (isset($_GET['status']))
			$status = $_GET['status'];

		$date = new jalaliDate();
		$where = ' WHERE 1';
		if ($status != 2)
			$where .= ' and status = ' . $status . ' ';
		if (isset($_GET['from']) && $_GET['from'])
			$where .= ' and created_at >= "' . date('Y-m-d 00:00:00', $date->makeTime($_GET['from'], 'jalali')) . '" ';
		if (isset($_GET['to']) && $_GET['to'])
			$where .= ' and created_at <= "' . date('Y-m-d 23:59:59', $date->makeTime($_GET['to'], 'jalali')) . '" ';


		global $wpdb;
		$query = "SELECT id,(select count(*) from {$wpdb->base_prefix}wra_reports as r where r.queue_id={$wpdb->base_prefix}wra_queue.id ) as retry FROM {$wpdb->base_prefix}wra_queue" . $where;
		$totalitems = $wpdb->query($query);
		
		$query = "SELECT *,(select count(*) from {$wpdb->base_prefix}wra_reports as r where r.queue_id={$wpdb->base_prefix}wra_queue.id ) as retry FROM {$wpdb->base_prefix}wra_queue" . $where;
		$orderby = !empty($_GET["orderby"]) ? $_GET["orderby"] : 'id';
		$order = !empty($_GET["order"]) ? $_GET["order"] : ' desc';
		if (!empty($orderby) & !empty($order)) {
			$query .= ' ORDER BY ' . $orderby . ' ' . $order;
		}

		
		$paged = !empty($_GET["paged"]) ? $_GET["paged"] : '';
		//Page Number
		if (empty($paged) || !is_numeric($paged) || $paged <= 0) {
			$paged = 1;
		}
		$totalpages = ceil($totalitems / $this->perpage);
		if (!empty($paged) && !empty($this->perpage)) {
			$offset = ($paged - 1) * $this->perpage;
			$query .= ' LIMIT ' . (int) $offset . ',' . (int) $this->perpage;
		}

		$this->set_pagination_args(
			array(
				"total_items" => $totalitems,
				"total_pages" => $totalpages,
				"per_page" => $this->perpage,
			)
		);


		$columns = $this->get_columns();

		$hidden = array();
		$sortable = $this->get_sortable_columns();
		$this->_column_headers = array($columns, $hidden, $sortable);


		$items = $wpdb->get_results($query);
		if ($items)
			foreach ($items as &$item)
				$item = (array) $item;
		$this->items = (array) $items;
	}
}