<?php

if (!class_exists('WP_List_Table')) {
	require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}
function wra_rest_api_reports_page_content()
{
	?>
	<link rel='stylesheet' href='<?php echo plugin_dir_url(__FILE__) ?>../assets/style.css'>
	<link rel="stylesheet" href="<?php echo plugin_dir_url(__FILE__) ?>../assets/persian-datepicker.css">
	<div class="wrap wra_report wra-page">
		<h1>گزارشات</h1>
		<div class="wra-table-box">
			<?php
			$wp_list_table = new Wra_Report_List_Table();
			$wp_list_table->prepare_items();
			$wp_list_table->display();
			?>
		</div>
	</div>
	<script src="<?php echo plugin_dir_url(__FILE__) ?>../assets/jquery-3.4.1.js"></script>
	<script src="<?php echo plugin_dir_url(__FILE__) ?>../assets/persian-date.js"> </script>
	<script src="<?php echo plugin_dir_url(__FILE__) ?>../assets/persian-datepicker.js"></script>
	<script>
		$(".wra-date-picker").pDatepicker(
			{
				format: 'YYYY/MM/DD', initialValue: false, initialValueType: 'persian'
			}
		);
	</script>
	<script>
		$('.copy-text').click(function (){
			const textToCopy = $(this).parent().find('.wra-data-view').html();
				navigator.clipboard.writeText(textToCopy)
					.then(() => alert("✅ متن کپی شد!"))
					.catch(err => alert("❌ خطا در کپی متن: " + err));
		});
		$('.copy-text-2').click(function (){
			const textToCopy = $(this).attr('data');
				navigator.clipboard.writeText(textToCopy)
					.then(() => alert("✅ متن کپی شد!\n  در نرم افزار postman در قسمت File->import متن کپی شده را وارد نمایید."))
					.catch(err => alert("❌ خطا در کپی متن: " + err));
		});
	</script>
	<?php
}


class Wra_Report_List_Table extends WP_List_Table
{
	public $row_index = 0;
	public $perpage = 20;

	public function __construct()
	{
		$paged = !empty($_GET["paged"]) ? $_GET["paged"] : 1;
		$this->row_index = ($paged - 1) * $this->perpage;

		parent::__construct(
			array(
				'singular' => 'test',
				'plural' => 'tests',
				'ajax' => false
			)
		);
	}

	function extra_tablenav($which)
	{
		if ($which == "top") {
			$date = new jalaliDate();
			$action = '';
			if (isset($_GET['action']) && $_GET['action'])
				$action = $_GET['action'];
			$status = -1;
			if (isset($_GET['status']) && $_GET['status'] != -1)
				$status = $_GET['status'];
			$from = '';
			if (isset($_GET['from']) && $_GET['from'])
				$from = $date->getNumberInPersian($_GET['from']);
			$to = '';
			if (isset($_GET['to']) && $_GET['to'])
				$to = $date->getNumberInPersian($_GET['to']);
			$json = '';
			if (isset($_GET['json']) && $_GET['json'])
				$json = $_GET['json'];
			$response = '';
			if (isset($_GET['response']) && $_GET['response'])
				$response = $_GET['response'];
				
				
			echo '
				<form class="wra-form" method="get">
					<div class="wra-row">
						<div class="wra-col"><label>آدرس وب سرویس</label>
							<select name="action">
								<option value=""></option>	
								<option value="GetTimeStamp" ' . (($action == 'GetTimeStamp') ? "selected" : "") . '>بررسی اتصال به نرم افزار</option>								
								<option value="Get Token" ' . (($action == 'Get Token') ? "selected" : "") . '>دریافت توکن</option>	
								<option value="GetProduct" ' . (($action == 'GetProduct') ? "selected" : "") . '>دریافت کالا</option>																				
								<option value="GetProducts" ' . (($action == 'GetProducts') ? "selected" : "") . '>دریافت لیست کالاها</option>
								<option value="addProduct" ' . (($action == 'addProduct') ? "selected" : "") . '>افزودن کالا</option>		
								<option value="updateProduct" ' . (($action == 'updateProduct') ? "selected" : "") . '>بروزرسانی کالا</option>	
								<option value="GetProductGroups" ' . (($action == 'GetProductGroups') ? "selected" : "") . '>دریافت لیست گروه ها</option>
								<option value="addGroup" ' . (($action == 'addGroup') ? "selected" : "") . '>افزودن گروه</option>		
								<option value="updateGroup" ' . (($action == 'updateGroup') ? "selected" : "") . '>بروزرسانی گروه</option>	
								<option value="FactorAdd" ' . (($action == 'FactorAdd') ? "selected" : "") . '>ارسال فاکتور</option>		
								<option value="manualUpdate" ' . (($action == 'manualUpdate') ? "selected" : "") . '>همگام سازی آنی</option>	
								<option value="CronJob" ' . (($action == 'CronJob') ? "selected" : "") . '>اجرای کرون جاب</option>	
								<option value="GetGoldPrice" ' . (($action == 'GetGoldPrice') ? "selected" : "") . '>دریافت قیمت طلا</option>						
							</select>
						</div>
						<div class="wra-col">
							<label>وضعیت</label>
							<select style="text-align: right;" name="status">
								<option value="-1"></option>	
								<option value="0" ' . (($status != 200 && $status >= 0) ? "selected" : "") . '>ناموفق</option>	
								<option value="200" ' . (($status == 200) ? "selected" : "") . '>موفقیت آمیز</option>	
							</select>
						</div>
						<input type="hidden" name="page" value="rest_api_reports">				
						<div class="wra-col"><label>تاریخ شروع</label><input name="from" class="wra-date-picker" value="' . $from . '" autocomplete="off"></div>
						<div class="wra-col"><label>تاریخ پایان</label><input name="to" class="wra-date-picker" value="' . $to . '" autocomplete="off"></div>

						<div class="wra-col"><label>پارامتر ورودی</label><input name="json" class="" value="' . $json . '" autocomplete="off"></div>
						<div class="wra-col"><label>پاسخ دریافتی</label><input name="response" class="" value="' . $response . '" autocomplete="off"></div>


						<div class="wra-col" style="direction: ltr;"><button class="button button-primary">جستجو</button></div>
					</div>
				</form>			
			';
		}
		if ($which == "bottom") {
			echo "";
		}
	}

	function get_columns()
	{
		$columns = array(
			'rw' => '#',
			'action' => 'متد فراخوانی شده',
			'status' => 'وضعیت',
			'address' => 'آدرس وب سرویس',
			'json' => 'پارامتر ورودی',
			'response' => 'پاسخ دریافتی',
			'description' => 'توضیحات',
			'insertTime' => 'ساعت و تاریخ فراخوانی',
			'updateTime' => 'ساعت و تاریخ دریافت پاسخ'
		);
		return $columns;
	}

	function get_sortable_columns()
	{
		return $sortable = array(
			'action' => array('action', false),
		);
	}


	function column_default($item, $column_name)
	{
		$date = new jalaliDate();
		switch ($column_name) {
			case 'rw':
				$this->row_index++;
				return $this->row_index;
			case 'action':	
				switch($item[$column_name]){
					case 'GetTimeStamp':return 'بررسی اتصال به نرم افزار ('.$item[$column_name].')';
					case 'Get Token':return 'دریافت توکن ('.$item[$column_name].')';
					case 'GetProduct':return 'دریافت کالا ('.$item[$column_name].')';
					case 'GetProducts':return 'دریافت لیست کالاها ('.$item[$column_name].')';
					case 'addProduct':return 'افزودن کالا ('.$item[$column_name].')';
					case 'updateProduct':return 'بروزرسانی کالا ('.$item[$column_name].')';
					case 'GetProductGroups':return 'دریافت لیست گروه ها ('.$item[$column_name].')';
					case 'addGroup':return 'افزودن گروه ('.$item[$column_name].')';
					case 'updateGroup':return 'بروزرسانی گروه ('.$item[$column_name].')';
					case 'FactorAdd':return 'ارسال فاکتور ('.$item[$column_name].')';
					case 'manualUpdate':return 'همگام سازی آنی ('.$item[$column_name].')';
					case 'CronJob':return 'اجرای کرون جاب';
					case 'GetGoldPrice':return 'دریافت قیمت طلا';
					default : return $item[$column_name];
				}
			case 'address':
			case 'status':
			case 'description':
				return $item[$column_name];
			case 'json':



				$url = '';
				$first_part = '';

				if($item['address'])
				{				
					$url = explode('/',$item['address']);

					if($url && $url[0])
						$first_part= explode(':',$url[0]);
						array_shift($url);
				}


				$data_show = ($item[$column_name] && json_decode($item[$column_name]))  ? json_encode(json_decode($item[$column_name]), JSON_PRETTY_PRINT |JSON_UNESCAPED_UNICODE |JSON_UNESCAPED_SLASHES |JSON_HEX_TAG |JSON_HEX_AMP |JSON_HEX_QUOT |JSON_HEX_APOS) : "";
				$postman_json = json_encode([
						"info"=> [
						  "name"=> "Pejvak Api",
						  "_postman_id"=> "a1b2c3d4-e5f6-7890-abcd-ef1234567890",
						  "schema"=> "https://schema.getpostman.com/json/collection/v2.1.0/collection.json"
						],
						"item"=> [	
							[					
								"name"=> $item['action'],
								"request"=> [
								"method"=> "POST",	
								// "protocol": "https",
								"header"=> [
									[
									  "key"=> "Content-Type",
									  "value"=> "application/json"
									]
								  ],						  
								"body"=> [
									"mode"=> "raw",
									"raw"=> json_encode(json_decode($item['json']),JSON_PRETTY_PRINT |JSON_UNESCAPED_UNICODE)
								],
								"url"=> [
									"raw"=> $item['address'],
									"host"=> isset($first_part[0]) ? [$first_part[0]] : [],
									"port"=> isset($first_part[1]) ? $first_part[1] : "",
									"path"=> $url
									]
								] 
							]
							
						]
									  
					], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
			
				
				


				if ($data_show) { 
					return '<div style="width:100%;height: 150px;direction: ltr;overflow: auto;border: 1px solid gray; position: relative; resize: both;overflow: auto;background-color: white;"><pre class="wra-data-view" style="white-space: break-spaces;font-size: 12px;width: 95%;margin: auto;">' . $data_show . '</pre></div><button class="copy-text button button-primary" style="margin-top: 5px;">کپی</button> <button class="copy-text-2 button button-primary" data=\''.$postman_json.'\' style="margin-top: 5px;">Postman</button>';

				} elseif($item[$column_name])
				{
					return '<div style="width:100%;height: 150px;direction: ltr;overflow: auto;border: 1px solid gray; position: relative; resize: both;overflow: auto;background-color: white;">'.nl2br($item[$column_name]).'</div>';
				}
				else
				{
				return '<div style="direction: rtl;">'.nl2br($item[$column_name]).'</div>';
				}


			case 'response':
				$data_show = ($item[$column_name] && json_decode($item[$column_name]))  ? json_encode(json_decode($item[$column_name]), JSON_PRETTY_PRINT |JSON_UNESCAPED_UNICODE |JSON_UNESCAPED_SLASHES |JSON_HEX_TAG |JSON_HEX_AMP |JSON_HEX_QUOT |JSON_HEX_APOS) : "";
				if ($data_show) { 
					return '<div style="width:100%;height: 150px;direction: ltr;overflow: auto;border: 1px solid gray; position: relative; resize: both;overflow: auto;background-color: white;"><pre class="wra-data-view" style="white-space: break-spaces;font-size: 12px;width: 95%;margin: auto;">' . $data_show . '</pre></div><button class="copy-text button button-primary" style="margin-top: 5px;">کپی</button>';

				} elseif($item[$column_name])
				{
					return '<div class="wra-data-view" style="width:100%;height: 150px;direction: ltr;overflow: auto;border: 1px solid gray; position: relative; resize: both;overflow: auto;background-color: white;">'.nl2br($item[$column_name]).'</div><button class="copy-text button button-primary" style="margin-top: 5px;">کپی</button>';
				}
				else
				{
				return '<div style="direction: rtl;">'.nl2br($item[$column_name]).'</div>';
				}
			case 'insertTime':
			case 'updateTime':
				return $date->getDate($item[$column_name]);
			default:
				return print_r($item, true);
		}
	}

	function prepare_items()
	{
		$date = new jalaliDate();
		$where = 'WHERE 1';
		if (isset($_GET['action']) && $_GET['action'])
		{
			$action=$_GET['action'];
			if($action == 'GetProduct')$action='GetProductById';  
			$where .= ' and action = "' . $action . '" '; 
		}

		if (isset($_GET['status']) && $_GET['status'] != -1 && $_GET['status'] >= 0) {
			if ($_GET['status'] == 200)
				$where .= ' and status = 200 ';
			else
				$where .= ' and status != 200 ';
		}
		if (isset($_GET['from']) && $_GET['from'])
			$where .= ' and insertTime >= "' . date('Y-m-d 00:00:00', $date->makeTime($_GET['from'], 'jalali')) . '" ';
		if (isset($_GET['to']) && $_GET['to'])
			$where .= ' and insertTime <= "' . date('Y-m-d 23:59:59', $date->makeTime($_GET['to'], 'jalali')) . '" ';

		if (isset($_GET['queue']))
			$where .= ' and queue_id=' . $_GET['queue'] . ' ';

		if (isset($_GET['json']))
			$where .= ' and json like "%' . $_GET['json'] . '%" ';

			if (isset($_GET['response']))
			$where .= ' and response like "%' . $_GET['response'] . '%" ';


		if (isset($_GET['p']))
			$where .= ' and (action = "addProduct" or action = "updateProduct") and (json like \'%"sku":"' . $_GET['p'] . '",%\' or json like \'%"productCode":"' . $_GET['p'] . '",%\' ) '; 

		if (isset($_GET['g']))
			$where .= ' and (action = "addGroup" or action = "updateGroup") and (json like \'%"id":' . $_GET['g'] . ',%\' or json like \'%"group_id":"' . $_GET['g'] . '",%\') ';


		if (isset($_GET['productId']) && $_GET['productId'])
		{
			global $wpdb;
			$query = "SELECT * FROM {$wpdb->base_prefix}wra_products_map where productId = ".$_GET['productId'];
			$product_list = $wpdb->get_results($query);
			if($product_list)
				$where .= ' and (action = "addProduct" or action = "updateProduct") and json like \'%"productID":'.$product_list[0]->apiProductId.',%\' ';
		}



		global $wpdb;
		
		$query = "SELECT id FROM {$wpdb->base_prefix}wra_reports " . $where;


		$totalitems = $wpdb->query($query);
		
		$query = "SELECT * FROM {$wpdb->base_prefix}wra_reports " . $where;
		$orderby = !empty($_GET["orderby"]) ? $_GET["orderby"] : 'id';
		$order = !empty($_GET["order"]) ? $_GET["order"] : ' desc';

		if (!empty($orderby) & !empty($order)) {
			$query .= ' ORDER BY ' . $orderby . ' ' . $order;
		}
		
		
		$paged = !empty($_GET["paged"]) ? $_GET["paged"] : '';
		//Page Number
		if (empty($paged) || !is_numeric($paged) || $paged <= 0) {
			$paged = 1;
		}
		$totalpages = ceil($totalitems / $this->perpage);
		if (!empty($paged) && !empty($this->perpage)) {
			$offset = ($paged - 1) * $this->perpage;
			$query .= ' LIMIT ' . (int) $offset . ',' . (int) $this->perpage;
		}

		$this->set_pagination_args(
			array(
				"total_items" => $totalitems,
				"total_pages" => $totalpages,
				"per_page" => $this->perpage,
			)
		);


		$columns = $this->get_columns();

		$hidden = array();
		$sortable = $this->get_sortable_columns();
		$this->_column_headers = array($columns, $hidden, $sortable);


		$items = $wpdb->get_results($query);
		if ($items)
			foreach ($items as &$item)
				$item = (array) $item;
		$this->items = (array) $items;
	}
}