<?php

function wra_rest_api_settings_page_content()
{ 
	if(get_option('wra_state')=='on')
		wra_settings_page_notify();

	$active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'general';
	
	?>
	<link rel='stylesheet' href='<?php echo plugin_dir_url(__FILE__) ?>../assets/style.css'>
	<div class="wrap wra-page">
		<h1>تنظیمات</h1>

        <h2 class="nav-tab-wrapper">
            <a href="?page=rest_api_settings&tab=general" class="nav-tab <?php echo $active_tab == 'general' ? 'nav-tab-active' : ''; ?>">وضعیت</a>
            <a href="?page=rest_api_settings&tab=setting" class="nav-tab <?php echo $active_tab == 'setting' ? 'nav-tab-active' : ''; ?>">تنظیمات</a>
			<a href="?page=rest_api_settings&tab=gold" class="nav-tab <?php echo $active_tab == 'gold' ? 'nav-tab-active' : ''; ?>">طلا</a>
			<a href="?page=rest_api_settings&tab=api" class="nav-tab <?php echo $active_tab == 'api' ? 'nav-tab-active' : ''; ?>">وب سرویس</a>
			<a href="?page=rest_api_settings&tab=optimization" class="nav-tab <?php echo $active_tab == 'optimization' ? 'nav-tab-active' : ''; ?>">بهینه سازی</a>
        </h2>
        <div class="tab-content">
            <?php
            if ($active_tab == 'general') {
                wra_setting_page_tab_1();
            } 
			elseif ($active_tab == 'setting') {
                wra_setting_page_tab_2();
            }
			elseif ($active_tab == 'optimization') {
                wra_setting_page_tab_3();
            } 
			elseif ($active_tab == 'api') {
                wra_setting_page_tab_4();
            } 
			elseif ($active_tab == 'gold') {
                wra_setting_page_tab_5();
            } 
			

            ?>
        </div>
	</div>
	<script src="<?php echo plugin_dir_url(__FILE__) ?>../assets/jquery-3.4.1.js"></script>
	<script src="<?php echo plugin_dir_url(__FILE__) ?>../assets/main.js"></script>
	<?php
	
	

	
	
	
	
}


function wra_setting_page_tab_1()
{
	?>
		<form method="post" action="options.php">
			<?php
			settings_fields('wra_list_settings_1');
			do_settings_sections('wra_list_1');
			// submit_button();
			?>
		</form>
	<?php
}
function wra_setting_page_tab_2()
{
	?>
		<form method="post" action="options.php">
			<?php
			settings_fields('wra_list_settings_2');
			do_settings_sections('wra_list_2');
			submit_button();
			?>
		</form>
	<?php
}
function wra_setting_page_tab_3()
{
	?>
		<form method="post" action="options.php">
			<?php
			settings_fields('wra_list_settings_3');
			do_settings_sections('wra_list_3');
			submit_button();
			?>
		</form>
	<?php
}
function wra_setting_page_tab_4()
{
	?>
		<form method="post" action="options.php">
			<?php
			settings_fields('wra_list_settings_4');
			do_settings_sections('wra_list_4');
			submit_button();
			?>
		</form>
	<?php
}

function wra_setting_page_tab_5()
{
	?>
		<form method="post" action="options.php">
			<?php
			settings_fields('wra_list_settings_5');
			do_settings_sections('wra_list_5');
			submit_button();
			?>
		</form>
	<?php
}


// 
function wra_settings_page_notify()
{
	global $wpdb;
	// بررسی صف ارسال
	$query = "SELECT * FROM {$wpdb->base_prefix}wra_queue where status=0";
	$totalitems = $wpdb->query($query);
	if ($totalitems)
		echo '<div class="notice notice-warning is-dismissible"><p>
			شما ' . $totalitems . ' درخواست در صف ارسال دارید. <a href="admin.php?page=rest_api_queues">مشاهده</a>
		</p></div>';


	// بررسی کرون جاب
	$query = "SELECT insertTime FROM {$wpdb->base_prefix}wra_reports where action = 'CronJob' order by id desc limit 1";
	$report_list = $wpdb->get_results($query);
	if($report_list)
	{
		if($report_list[0]->insertTime<date('Y-m-d H:i:s', strtotime(date('Y-m-d').' -1 day')))
		{
			$date = new jalaliDate(); 
			$cron_job_date = $date->getDate($report_list[0]->insertTime);
			echo '	<div class="notice notice-warning is-dismissible">
						<p>
							آخرین اجرای کرون جاب سایت شما در '.$cron_job_date.' بوده است. لطفا از فعال بودن آن اطمینان حاصل نمایید.
						</p>
					</div>';
		}
	}
	else
	{
		echo '	<div class="notice notice-error is-dismissible">
					<p>
						کرون جاب بر روی سایت شما ثبت نشده و یا غیرفعال است. در صورت فعال نبودن همگام سازی خودکار انجام نخواهد شد.
					</p>
				</div>';
	}


	if( !(
			get_option('woocommerce_currency')=='IRR' && get_option('wra_priceInApp') == 'ریال' || 
			get_option('woocommerce_currency')=='IRT' && get_option('wra_priceInApp') == 'تومان'
		)
	)
	{
		echo '	<div class="notice notice-error is-dismissible">
					<p>
						واحد پولی در سایت و نرم افزار یکسان نمی باشد. لطفا واحد ها را یکسان کنید.
					</p>
				</div>';
	}


	


}











// setting page
add_action('admin_init', 'wra_rest_settings_fields_1');
function wra_rest_settings_fields_1()
{
	wra_check_tables();
	$page_slug = 'wra_list_1';
	$option_group = 'wra_list_settings_1';

	// 1. create section
	add_settings_section(
		'rest_section_id',
		'',
		'',
		$page_slug
	);






	$connection = get_option('wra_state');

	$active_button = ' <button type="button" class="button button-primary" style="font-size: 12px;padding-bottom: 2px;margin-top: -5px;margin-right: 7px;" id="check-connection" onclick="window.location=\'?page=rest_api_settings&tab=setting\'">فعالسازی</button>';
	add_settings_field(
		'text1',
		'وضعیت وب سرویس',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => $connection=='on' ? '<span style="color:green;font-weight: bold;">فعال</span>' : '<span style="color:red;font-weight: bold;">غیرفعال</span>'.$active_button,
		)
	);




	$connection = get_option('wra_connect');
	$connection_text = '';
	switch ($connection) {
		case 0:
			$connection_text = '<span style="color:black;font-weight: bold;">تا بحال ارتباط برقرار نشده است</span>';
			break;
		case 1:
			$connection_text = '<span style="color:green;font-weight: bold;">ارتباط با موفقیت برقرار شد</span>';
			break;
		case -2:
			$connection_text = '<span style="color:red;font-weight: bold;">عدم ارتباط با وب سرویس</span>';
			break;
		case -1:
			$connection_text = '<span style="color:#ff8b00;font-weight: bold;">ارتباط با وب سرویس برقرار شد (ارتباط با دیتابیس برقرار نیست)</span>';
			break;
		default:
			$connection_text = '<span style="color:black;font-weight: bold;">تا بحال ارتباط برقرار نشده است</span>';
			break;
	}
	$connection_text .= ' <button type="button" class="button button-primary" style="font-size: 12px;padding-bottom: 2px;margin-top: -5px;margin-right: 7px;" id="check-connection" onclick="window.location=\'?page=rest_api_settings&check-connection\'">بررسی مجدد</button>';



	add_settings_field(
		'text2',
		'وضعیت اتصال به نرم افزار حسابداری',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => $connection_text
		)
	);








	add_settings_field(
		'button',
		'همگام سازی',
		'wra_form_buttons',
		$page_slug,
		'rest_section_id',
		array(
			'link' => '?page=rest_api_settings&wra_update=1',
			'class' => '',
			'name' => 'button',
			'text' => 'همگام سازی آنی'
		)
	);

	if (intval(get_option('wra_total_products')) > 0) {
		add_settings_field(
			'update_text',
			'آخرین کالاهای دریافت شده',
			'wra_form_html',
			$page_slug,
			'rest_section_id',
			array(
				'text' => get_option('wra_from_product') . ' تا ' . get_option('wra_to_product') . ' از ' . get_option('wra_total_products') . ' کالا'
			)
		);
	}






	$addr = null;
	if(function_exists('socket_create') && function_exists('socket_connect'))
	{
			$sock = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP);
			$res = socket_connect($sock, '8.8.8.8', 53);
			socket_getsockname($sock, $addr);
			socket_shutdown($sock);
			socket_close($sock);

			if ($addr) {
				add_settings_field(
					'text4',
					'IP جهت درج در نرم افزار',
					'wra_form_html',
					$page_slug,
					'rest_section_id',
					array(
						'text' => '<b>' . $addr . '</b>'
					)
				);
			} else {
				add_settings_field(
					'text5',
					'IP جهت درج در نرم افزار',
					'wra_form_html',
					$page_slug,
					'rest_section_id',
					array(
						'text' => '<span style="color:red;font-weight: bold;">جهت دریافت IP با مدیریت هاست خود در ارتباط باشید.</span>'
					)
				);
			}
		

	}
	else
	{
		add_settings_field(
			'text6',
			'IP جهت درج در نرم افزار',
			'wra_form_html',
			$page_slug,
			'rest_section_id',
			array(
				'text' => '<span style="color:red;font-weight: bold;">Socket بر روی هاست شما غیرفعال است. جهت دریافت IP با مدیریت هاست خود در ارتباط باشید.</span>'
			)
		);
	}



	// add_settings_field(
	// 	'text7',
	// 	'IP جهت درج در نرم افزار',
	// 	'wra_form_html',
	// 	$page_slug,
	// 	'api_ip_log',
	// 	array(
	// 		'text' => $addr
	// 	)
	// );


		add_settings_field(
			'text8',
			'نسخه PHP ',
			'wra_form_html',
			$page_slug,
			'rest_section_id',
			array(
				'text' => '<b>' . phpversion() . '</b> 
				<button type="button" class="button button-primary" style="font-size: 12px;padding-bottom: 2px;margin-top: -5px;margin-right: 7px;" id="check-connection" onclick="window.location=\'?php-info\'"> phpinfo </button>
				'
			)
		);
	


	global $wp_version;
	if ($wp_version) {
		add_settings_field(
			'text9',
			'نسخه وردپرس ',
			'wra_form_html',
			$page_slug,
			'rest_section_id',
			array(
				'text' => '<b>' . $wp_version . '</b>'
			)
		);
	}

		add_settings_field(
			'text10',
			'نسخه ووکامرس ', 
			'wra_form_html',
			$page_slug,
			'rest_section_id',
			array(
				'text' => '<b>' . (function_exists('WC') ? WC()->version : '<span style="color:red;">یافت نشد</span>')  . '</b>'
			)
		);
		



	add_settings_field(
		'text12',
		'نسخه api ',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => '<b>1.0.1</b>'
		)
	);





	global $wpdb;
	$query = "SELECT insertTime FROM {$wpdb->base_prefix}wra_reports where action = 'CronJob' order by id desc limit 1";
	$report_list = $wpdb->get_results($query);
	if($report_list)
	{
		$date = new jalaliDate(); 
		if($report_list[0]->insertTime<date('Y-m-d H:i:s', strtotime(date('Y-m-d').' -1 day')))
			$cron_job_date = '<span style="color:#f97300;font-weight: bold;">'.$date->getDate($report_list[0]->insertTime).'</span>';
		else
			$cron_job_date = '<span style="color:green;font-weight: bold;">'.$date->getDate($report_list[0]->insertTime).'</span>';
	}
	else
	{
		$cron_job_date = '<span style="color:red;font-weight: bold;">ثبت نشده</span>';
	}

	add_settings_field(
		'text13',
		'فعالسازی cron job',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => '
			آخرین زمان اجرا: '.$cron_job_date.'
			<br><br>
			برای تعریف cron job وارد کنترل پنل هاست خود شود و از قسمت cron job دستور زیر را وارد نمایید:
			<br><br>
			CPanel:
			<br>
			<div class="wra-code-view"><b>curl -s ' . get_site_url() . '?wra_cron_job=1</b><b>بروزرسانی کالاها</b></div>
			<br>
			<div class="wra-code-view d-flex justify-content-between"><b>curl -s ' . get_site_url() . '?wra_gold_cron_job=1</b><b>دریافت قیمت طلا</b></div>
			<br>
			Direct Admin:<br>
			<div class="wra-code-view"><b>/usr/bin/wget -q -O /dev/null "' . get_site_url() . '?wra_cron_job=1" >/dev/null 2>&1</b><b>بروزرسانی کالاها</b></div>
			<br>
			<div class="wra-code-view"><b>/usr/bin/wget -q -O /dev/null "' . get_site_url() . '?wra_gold_cron_job=1" >/dev/null 2>&1</b><b>دریافت قیمت طلا</b></div>
			<br>
			Plesk:<br>
			وارد قسمت Scheduled Tasks شوید و روی Add Task کلیک کنید سپس Fetch a URL  را انتخاب و مقدار url را وارد کنید:
			<br>
			<div class="wra-code-view"><b>' . get_site_url() . '?wra_cron_job=1	</b><b>بروزرسانی کالاها</b></div>
			<br>
			<div class="wra-code-view"><b>' . get_site_url() . '?wra_gold_cron_job=1 </b><b>دریافت قیمت طلا</b></div>
			'
		)
	);

	

}



// setting page
add_action('admin_init', 'wra_rest_settings_fields_2');
function wra_rest_settings_fields_2()
{
	wra_check_tables();
	$page_slug = 'wra_list_2';
	$option_group = 'wra_list_settings_2';

	// 1. create section
	add_settings_section(
		'rest_section_id',
		'',
		'',
		$page_slug
	);

	



	register_setting($option_group, 'wra_state', 'string');

	add_settings_field(
		'wra_state',
		'وب سرویس فعال باشد',
		'wra_form_chkbox',
		$page_slug,
		'rest_section_id',
		array(
			'name' => 'wra_state'
		)
	);

	register_setting($option_group, 'wra_ip', 'string');
	add_settings_field(
		'wra_ip',
		'IP',
		'wra_form_input',
		$page_slug,
		'rest_section_id',
		array(
			'label_for' => 'wra_ip',
			'class' => 'hello',
			'name' => 'wra_ip'
		)
	);

	register_setting($option_group, 'wra_port', 'string');
	add_settings_field(
		'wra_port',
		'PORT',
		'wra_form_input',
		$page_slug,
		'rest_section_id',
		array(
			'label_for' => 'wra_port',
			'class' => 'hello',
			'name' => 'wra_port'
		)
	);


	add_settings_field(
		'text14',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'اطلاعات IP و PORT جهت اتصال به سرور نرم افزار حسابداری است. (IP static)<br>
			معمولا سرورها پورت هایی به غیر از 80، 8080، 443 و 25 را مسدود می کنند (ترجیحا از پورت های 80 یا 443 استفاده نمایید).
			'
		)
	);


	if(get_option('wra_ip'))
		add_settings_field(
			'text15',
			'',
			'wra_form_html',
			$page_slug,
			'rest_section_id',
			array(
				'text' => ' <a href="http://'.get_option('wra_ip').':'.get_option('wra_port').'/WebApiService" target="_blank" class="button button-primary" style="font-size: 12px;padding-bottom: 2px;margin-top: -5px;">باز کردن صفحه وب سرویس</a>'

			)
		);





	register_setting($option_group, 'wra_api_key', 'string');
	add_settings_field(
		'wra_api_key',
		'API KEY',
		'wra_form_input',
		$page_slug,
		'rest_section_id',
		array(
			'label_for' => 'wra_api_key',
			'class' => 'hello',
			'name' => 'wra_api_key'
		)
	);

	add_settings_field(
		'text16',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'کلید تبادل دریافتی از نرم افزار حسابداری'
		)
	);


	// register_setting($option_group, 'wra_time', 'string');
	// register_setting($option_group, 'wra_day', 'string');
	// register_setting($option_group, 'wra_hours', 'string');
	// register_setting($option_group, 'wra_hour', 'string');
	// register_setting($option_group, 'wra_minute', 'string');
	// add_settings_field(
	// 	'wra_period',
	// 	'بازه همگام سازی اطلاعات',
	// 	'wra_form_period',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'label_for' => 'wra_period',
	// 		'class' => 'hello',
	// 		'name' => 'wra_period'
	// 	)
	// );







	register_setting($option_group, 'wra_updates', 'string');
	add_settings_field(
		'wra_updates',
		'تعداد بروزرسانی در هر لحظه',
		'wra_form_input',
		$page_slug,
		'rest_section_id',
		array(
			'label_for' => 'wra_updates',
			'class' => 'hello',
			'name' => 'wra_updates',
			'text' => 'عدد'

		)
	);


	add_settings_field(
		'text17',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'مشخص می نماید در هر درخواست چه تعداد محصول بروزرسانی شوند. (با توجه به قدرت سرور سایت این گزینه را انتخاب نمایید)'
		)
	);



	register_setting($option_group, 'wra_developer_mode', 'wra_rest_sanitize_checkbox');
	add_settings_field(
		'wra_developer_mode',
		'حالت توسعه دهنده',
		'wra_form_chkbox',
		$page_slug,
		'rest_section_id',
		array(
			'name' => 'wra_developer_mode'
		)

	);

	add_settings_field(
		'text18',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'جهت ثبت و مشاهده لاگ های عملکرد وب سرویس، این گزینه را فعال نمایید'
		)
	);











}



// setting page
add_action('admin_init', 'wra_rest_settings_fields_3');
function wra_rest_settings_fields_3()
{
	wra_check_tables();
	$page_slug = 'wra_list_3';
	$option_group = 'wra_list_settings_3';

	// 1. create section
	add_settings_section(
		'rest_section_id',
		'',
		'',
		$page_slug
	);

	

	add_settings_field(
		'text19',
		'پاکسازی جدول گزارشات',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => '<button type="button" class="button button-primary" style="font-size: 12px;padding-bottom: 2px;margin-top: -5px;margin-right: 7px;" id="wra-clear-database" onclick="if(confirm(\'آیا مایل به پاکسازی گزارشات هستید؟\')) window.location=\'?page=rest_api_settings&wra_clear_database\'">پاکسازی</button>'
		)
	);

	add_settings_field(
		'text20', 
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'با زدن دکمه پاکسازی همه گزارشات و گزارشات صف ارسال بغیر از فاکتورهای در انتظار ارسال پاک خواهد شد.'
		)
	);



	add_settings_field(
		'text21',
		'حجم جدول گزارشات',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => wra_get_table_size('wra_reports')
		)
	);




	register_setting($option_group, 'wra_clear_db_state', 'string');

	add_settings_field(
		'wra_clear_db_state',
		'پاکسازی خودکار گزارشات',
		'wra_form_chkbox',
		$page_slug,
		'rest_section_id',
		array(
			'name' => 'wra_clear_db_state'
		)
	);

	if(!get_option('wra_clear_db_days'))
		update_option('wra_clear_db_days', 30);
	register_setting($option_group, 'wra_clear_db_days', 'string');
	add_settings_field(
		'wra_clear_db_days',
		'تعداد روز گذشته از ثبت گزارش',
		'wra_form_input',
		$page_slug,
		'rest_section_id',
		array(
			'label_for' => 'wra_clear_db_days',
			'class' => 'hello',
			'name' => 'wra_clear_db_days'
		)
	);

	add_settings_field(
		'text22', 
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در صورت فعال بودن پاکسازی خودکار گزارشات، گزارشاتی که به تعداد روز مشخص شده از آن ها گذشته باشد به صورت خودکار حذف خواهند شد و قابل بازیابی نیستند.<br>برای اجرای خودکار پاکسازی کرون جاب باید فعال باشد.'
			)
	);


}



// setting page
add_action('admin_init', 'wra_rest_settings_fields_4');
function wra_rest_settings_fields_4()
{
	wra_check_tables();
	$page_slug = 'wra_list_4';
	$option_group = 'wra_list_settings_4';

	// 1. create section
	add_settings_section(
		'rest_section_id',
		'',
		'',
		$page_slug
	);

	

	//register_setting($option_group, 'wra_priceInWC', 'string');
	add_settings_field(
		'wra_priceInWC',
		'واحد پول در ووکامرس',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => '<p class="pt-1">'.
			(get_option('woocommerce_currency') == 'IRT' ? 'تومان' : '').
			(get_option('woocommerce_currency') == 'IRR' ? 'ریال' : '').
			((get_option('woocommerce_currency') != 'IRR' && get_option('woocommerce_currency') != 'IRT')  ? '<span style="color:red;">'.__(get_option('woocommerce_currency')). '<br>لطفا واحد پولی را به ریال یا تومان تغییر دهید.</span>' : '').
			'</p> <br><a class="button button-primary" href="?page=wc-settings">تغییر واحد پولی</a>'
		)      
	);


	// add_settings_field(
	// 	'wra_priceInWC',
	// 	'قیمت ها در ووکامرس',
	// 	'wra_form_select',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'label_for' => 'wra_priceInWC',
	// 		'class' => 'hello',
	// 		'name' => 'wra_priceInWC',
	// 		'options' => ['ریال', 'تومان']

	// 	)
	// );

	register_setting($option_group, 'wra_priceInApp', 'string');
	add_settings_field(
		'wra_priceInApp',
		'واحد پول در نرم افزار',
		'wra_form_select',
		$page_slug,
		'rest_section_id',
		array(
			'label_for' => 'wra_priceInApp',
			'class' => 'hello',
			'name' => 'wra_priceInApp',
			'options' => ['ریال', 'تومان']

		)
	);






	register_setting($option_group, 'wra_send_factor', 'wra_rest_sanitize_checkbox');
	add_settings_field(
		'wra_send_factor',
		'ارسال فاکتور به نرم افزار',
		'wra_form_chkbox',
		$page_slug,
		'rest_section_id',
		array(
			'name' => 'wra_send_factor'
		)
	);

	add_settings_field(
		'text23',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'فاکتورهای موفق در ووکامرس در نرم افزار حسابداری ایجاد شود یا خیر'
		)
	);



	register_setting($option_group, 'wra_get_title', 'wra_rest_sanitize_checkbox');
	add_settings_field(
		'wra_get_title',
		'دریافت نام کالا از نرم افزار',
		'wra_form_chkbox',
		$page_slug,
		'rest_section_id',
		array(
			'name' => 'wra_get_title'
		)
	);
	add_settings_field(
		'text24',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در صورتی که وب سرویس نرم افزار در دسترس باشد، در زمان دریافت کالا از نرم افزار، نام کالا دریافت می شود. (نام کالا در وب سایت با نام کالا در نرم افزار یکسان می شود)	'
		)
	);




	register_setting($option_group, 'wra_get_stock', 'wra_rest_sanitize_checkbox');
	add_settings_field(
		'wra_get_stock',
		'دریافت موجودی کالا از نرم افزار',
		'wra_form_chkbox',
		$page_slug,
		'rest_section_id',
		array(
			'name' => 'wra_get_stock'
		)
	);
	add_settings_field(
		'text25',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در صورتی که وب سرویس نرم افزار در دسترس باشد، در زمان دریافت کالا از نرم افزار و همچنین افزودن کالا به سبد خرید، موجودی کالا از نرم افزار استعلام می شود و موجودی کالا در نرم افزار معیار قرار داده می شود. (موجودی کالا در وب سایت در این لحظه با موجودی کالا در نرم افزار یکسان می شود)	'
		)
	);


	

	// register_setting($option_group, 'wra_update_images', 'wra_rest_sanitize_checkbox');
	// add_settings_field(
	// 	'wra_update_images',
	// 	'اعمال تصاویر کالاهای سایت براساس نرم افزار',
	// 	'wra_form_chkbox',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'name' => 'wra_update_images'
	// 	)
	// );
	// add_settings_field(
	// 	'text26',
	// 	'',
	// 	'wra_form_html',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'text' => 'در صورتی که این گزینه را انتخاب کرده باشید، تصویر شاخص کالا با تصویر ارسالی از نرم افزار جایگزین می شود و در صورتی که مایل باشید کالا تصاویر بیشتری داشته باشد، بایستی کالا را در وب سایت ویرایش کنید و تصاویر مد نظر را به گالری تصاویر هر کالا بیافزایید.'
	// 	)
	// );


	// register_setting($option_group, 'wra_update_price', 'wra_rest_sanitize_checkbox');
	// add_settings_field(
	// 	'wra_update_price',
	// 	'اعمال قیمت های سایت براساس قیمت کالاهای نرم افزار',
	// 	'wra_form_chkbox',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'name' => 'wra_update_price'
	// 	)
	// );
	// add_settings_field(
	// 	'text27',
	// 	'',
	// 	'wra_form_html',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'text' => 'در صورتی که این گزینه را انتخاب کرده باشید، قیمت کالاها در وب سایت و نرم افزار دقیقا مطابق با یکدیگر خواهد بود. توجه نمایید، در صورتی که کالاهای شما دارای خصوصیت باشد و قیمت های کالاها بر مبنای خصوصیت اعمال می گردد، این گزینه را فعال ننمایید. (چون در نرم افزار نمی توانید بر مبنای خصوصیت قیمت را اعمال کنید)'
	// 	)
	// );



	// register_setting($option_group, 'wra_update_discount', 'wra_rest_sanitize_checkbox');
	// add_settings_field(
	// 	'wra_update_discount',
	// 	'اعمال تخفیفات سایت براساس تخفیفات کالاهای نرم افزار',
	// 	'wra_form_chkbox',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'name' => 'wra_update_discount'
	// 	)
	// );
	// add_settings_field(
	// 	'text28',
	// 	'',
	// 	'wra_form_html',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'text' => 'در صورتی که این گزینه را انتخاب کرده باشید، تخفیفات کالاها در وب سایت و نرم افزار دقیقا مطابق با یکدیگر خواهد بود. توجه نمایید، در صورتی که کالاهای شما دارای خصوصیت باشد و قیمت های کالاها بر مبنای خصوصیت اعمال می گردد، این گزینه را فعال ننمایید. (چون در نرم افزار نمی توانید بر مبنای خصوصیت قیمت را اعمال کنید)'
	// 	)
	// );




	register_setting($option_group, 'wra_update_description', 'wra_rest_sanitize_checkbox');
	add_settings_field(
		'wra_update_description',
		'اعمال توضیحات سایت براساس توضیحات کالاهای نرم افزار',
		'wra_form_chkbox',
		$page_slug,
		'rest_section_id',
		array(
			'name' => 'wra_update_description'
		)
	);
	add_settings_field(
		'text29',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در صورتی که این گزینه را انتخاب کرده باشید، توضیحات کالاها در وب سایت و نرم افزار دقیقا مطابق با یکدیگر خواهد بود.'
		)
	);


	// مقدار پیش فرض بر روی فعال باشد
	if(!get_option('wra_update_groups'))
		update_option('wra_update_groups', 'on');

	register_setting($option_group, 'wra_update_groups', 'wra_rest_sanitize_checkbox');
	add_settings_field(
		'wra_update_groups',
		'دریافت گروه های کالا',
		'wra_form_chkbox',
		$page_slug,
		'rest_section_id',
		array(
			'name' => 'wra_update_groups'
		)
	);
	add_settings_field(
		'text30',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در صورتی که این گزینه را انتخاب کرده باشید، گروه های کالا از نرم افزار دریافت و در سایت اضافه می شوند.'
		)
	);


	// مقدار پیش فرض بر روی فعال باشد
	if(!get_option('wra_active_products'))
		update_option('wra_active_products', 'on');

	register_setting($option_group, 'wra_active_products', 'wra_rest_sanitize_checkbox');
	add_settings_field(
		'wra_active_products',
		'انتشار کالای جدید پس از دریافت از نرم افزار',
		'wra_form_chkbox',
		$page_slug,
		'rest_section_id',
		array(
			'name' => 'wra_active_products'
		)
	);
	add_settings_field(
		'text31',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در صورتی که این گزینه را انتخاب کرده باشید، کالاهای جدید پس از ثبت در سایت منتشر خواهد شد و در غیر اینصورت در وضعیت در انتظار بازبینی قرار خواهد گرفت.'
		)
	);







	register_setting($option_group, 'wra_save_action_logs', 'wra_rest_sanitize_checkbox');
	add_settings_field(
		'wra_save_action_logs',
		'ثبت گزارش پردازش اطلاعات دریافتی از نرم افزار',
		'wra_form_chkbox',
		$page_slug,
		'rest_section_id',
		array(
			'name' => 'wra_save_action_logs'
		)
	);

	add_settings_field(
		'text32',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در صورتی که این گزینه را انتخاب کرده باشید، گزارش پردازش محصولات، گروه ها و ... ثبت خواهد شد.'
		)
	);




	register_setting($option_group, 'wra_IsInsertPersonInfo', 'wra_rest_sanitize_checkbox');
	add_settings_field(
		'wra_IsInsertPersonInfo',
		'ثبت شخص در نرم افزار',
		'wra_form_chkbox',
		$page_slug,
		'rest_section_id',
		array(
			'name' => 'wra_IsInsertPersonInfo'
		)
	);
 
	add_settings_field(
		'text33',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در صورتی که این گزینه را انتخاب کرده باشید، شخص فاکتور در وب سایت، در نرم افزار ثبت می شود.'
		)
	);


	register_setting($option_group, 'wra_IsUpdatePersonInfo', 'wra_rest_sanitize_checkbox');
	add_settings_field(
		'wra_IsUpdatePersonInfo',
		'ویرایش شخص در نرم افزار',
		'wra_form_chkbox',
		$page_slug,
		'rest_section_id',
		array(
			'name' => 'wra_IsUpdatePersonInfo'
		)
	); 


	add_settings_field(
		'text34',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در صورتی که این گزینه را انتخاب کرده باشید، اطلاعات شخص فاکتور در وب سایت، در نرم افزار ویرایش می شود.'
		)
	);





}



// gold page
add_action('admin_init', 'wra_rest_settings_fields_5');
function wra_rest_settings_fields_5()
{
	wra_check_tables();
	$page_slug = 'wra_list_5';
	$option_group = 'wra_list_settings_5';

	// 1. create section
	add_settings_section(
		'rest_section_id',
		'',
		'',
		$page_slug
	);

	

	// register_setting($option_group, 'wra_interest_type', 'string');
	// add_settings_field(
	// 	'wra_interest_type',
	// 	'نوع سود',
	// 	'wra_form_select',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'label_for' => 'wra_interest_type',
	// 		'class' => 'hello',
	// 		'name' => 'wra_interest_type',
	// 		'options' => ['ریالی','درصدی']

	// 	)
	// );

	// add_settings_field(
	// 	'text39',
	// 	'',
	// 	'wra_form_html',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'text' => 'در این قسمت می توانید نوع سود را به درصد و یا ریال مشخص کنید.'
	// 	)
	// );


	// register_setting($option_group, 'wra_discount_type', 'string');
	// add_settings_field(
	// 	'wra_discount_type',
	// 	'نوع تخفیف',
	// 	'wra_form_select',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'label_for' => 'wra_discount_type',
	// 		'class' => 'hello',
	// 		'name' => 'wra_discount_type',
	// 		'options' => ['ریالی','درصدی']

	// 	)
	// );

	// add_settings_field(
	// 	'text40',
	// 	'',
	// 	'wra_form_html',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'text' => 'در این قسمت می توانید نوع تخفیف را به درصد و یا ریال مشخص کنید.'
	// 	)
	// );

	

	register_setting($option_group, 'wra_cron_job_status', 'string');
	add_settings_field(
		'wra_cron_job_status',
		' دریافت قیمت طلا از وب سرویس',
		'wra_form_chkbox',
		$page_slug,
		'rest_section_id',
		array(
			'name' => 'wra_cron_job_status',
			'class' => 'wra_cron_job_status',
		)
	);
	add_settings_field(
		'text40',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'با فعالسازی این گزینه به صورت خودکار قیمت طلا از وب سرویس قیمت طلا دریافت می شود.'
		)
	);
 


	register_setting($option_group, 'wra_gold_price', 'string');
	add_settings_field(
		'wra_gold_price',
		'قیمت طلای عیار 750 '. ' (تومان)',
		'wra_form_input',
		$page_slug,
		'rest_section_id',
		array(
			'label_for' => 'wra_gold_price',
			'class' => 'hello wra_deactive_price',
			'name' => 'wra_gold_price',
			'required' => 'required',
		)
	);

	add_settings_field(
		'text401',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در صورتی که وب سرویس دریافت قیمت طلا فعال نباشد می توانید قیمت پایه طلای عیار 750 را وارد نمایید.'
		)
	);





	register_setting($option_group, 'wra_gold_web_service', 'string');
	add_settings_field(
		'wra_gold_web_service',
		'وب سرویس دریافت قیمت طلا',
		'wra_form_select2',
		$page_slug,
		'rest_section_id',
		array(
			'label_for' => 'wra_gold_web_service',
			'class' => 'wra_gold_web_service wra_active_price',
			'name' => 'wra_gold_web_service',
			'options' => [	'' => '', 
							'zarbaha' => 'زربها', 
							'taban' => 'تابان گوهر نفیس', 
							'ratebox' => 'ریت باکس'
						]

		)
	);

	add_settings_field(
		'text41',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در این قسمت می توانید وب سرویس دریافت قیمت طلای 18 عیار را مشخص کنید.<br>
						<b>برای دریافت سرویس API بر روی <a href="https://tabangohar.com/api/" target="_blank" style="text-decoration: none;">تابان گوهر نفیس</a>, <a href="https://ratesbox.ir/webapi/" target="_blank" style="text-decoration: none;">ریت باکس</a> یا <a href="https://web.zarbaha-co.ir/" target="_blank" style="text-decoration: none;">زربها</a> کلیک کنید. </b>'
		)
	);



	register_setting($option_group, 'wra_gold_web_service_username', 'string');
	add_settings_field(
		'wra_gold_web_service_username',
		'نام کاربری وب سرویس',
		'wra_form_input',
		$page_slug,
		'rest_section_id',
		array(
			'label_for' => 'wra_gold_web_service_username',
			'class' => 'hello wra_active_price',
			'name' => 'wra_gold_web_service_username',
			'required' => 'required',
		)
	);
	register_setting($option_group, 'wra_gold_web_service_password', 'string');
	add_settings_field(
		'wra_gold_web_service_password',
		'رمز عبور وب سرویس',
		'wra_form_input',
		$page_slug,
		'rest_section_id',
		array(
			'label_for' => 'wra_gold_web_service_password',
			'class' => 'hello wra_active_price',
			'name' => 'wra_gold_web_service_password',
			'required' => 'required',
		)
	);
	
	register_setting($option_group, 'wra_gold_web_service_token', 'string');
	add_settings_field(
		'wra_gold_web_service_token',
		'توکن وب سرویس',
		'wra_form_input',
		$page_slug,
		'rest_section_id',
		array(
			'label_for' => 'wra_gold_web_service_token',
			'class' => 'hello wra_active_price',
			'name' => 'wra_gold_web_service_token',
			'required' => 'required',
		)
	);



	add_settings_field(
		'text43',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در صورتی که وب سرویس نام کاربری و رمز عبور دارد آن را وارد نمایید.' 
		)
	);


	
	$wra_gold_web_service = '';
	switch(get_option('wra_gold_price_service'))
	{
		case 'zarbaha': $wra_gold_web_service = ' (زربها)'; break;
		case 'taban': $wra_gold_web_service = ' (تابان گوهر نفیس)'; break;
		case 'ratebox': $wra_gold_web_service = ' (ریت باکس)'; break;		
	}

	add_settings_field(
		'text35',
		'قیمت لحظه ای طلا',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => '<div class="wra_price_box"><span >'.number_format(intval(get_option('wra_gold_price'))).'</span> تومان <span><br>زمان آخرین دریافت:'.(get_option('wra_gold_price_date') ? get_option('wra_gold_price_date') : '---').$wra_gold_web_service.'</span></div>' 
		)
	);

	add_settings_field(
		'button',
		'',
		'wra_form_buttons',
		$page_slug,
		'rest_section_id',
		array(
			'link' => '',
			'class' => 'wra_gold_price wra_active_price',
			'name' => 'button',
			'text' => 'دریافت قیمت طلا'
		)
	);

	add_settings_field(
		'gold_report',
		'',
		'wra_form_buttons',
		$page_slug,
		'rest_section_id',
		array(
			'link' => '?page=rest_api_reports&action=GetGoldPrice',
			'class' => 'wra_active_price',
			'name' => 'button',
			'text' => 'گزارش دریافت قیمت طلا'
		)
	);



	register_setting($option_group, 'wra_reset_price', 'string');
	add_settings_field(
		'wra_reset_price',
		'مدت زمان صفر شدن قیمت کالا پس از دریافت قیمت (دقیقه)',
		'wra_form_input',
		$page_slug,
		'rest_section_id',
		array(
			'label_for' => 'wra_reset_price',
			'class' => 'hello wra_active_price',
			'name' => 'wra_reset_price',
		)
	);
	
	add_settings_field(
		'text42',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در این قسمت می توانید مدت زمان صفر شدن قیمت کالا پس از دریافت قیمت را مشخص کنید. پس از گذشت این زمان درصورت دریافت نشدن قیمت، به صورت خودکار قیمت کالا صفر خواهد شد و امکان خرید کالا برای مشتری وجود ندارد.مقدار صفر به معنای عدم صفر شدن قیمت است.'
		)
	);








	register_setting($option_group, 'wra_cron_job_time', 'string');
	add_settings_field(
		'wra_cron_job_time',
		'فاصله بین دو فراخوانی وب سرویس طلا (دقیقه)',
		'wra_form_input',
		$page_slug,
		'rest_section_id',
		array(
			'label_for' => 'wra_cron_job_time',
			'class' => 'hello wra_active_price',
			'name' => 'wra_cron_job_time',
		)
	);

	add_settings_field(
		'text420',
		'',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => 'در این قسمت می توانید فاصله زمانی بین فراخوانی های دریافت قیمت طلا از وب سرویس را تعیین نمایید.'
		)
	);



	add_settings_field(
		'text37',
		'شورتکدها',
		'wra_form_html',
		$page_slug,
		'rest_section_id',
		array(
			'text' => "
						<table id='price_fields_table1' class='wra-table'>
							<thead>
								<tr>
									<th style='min-width: 150px;'>کاربرد</th>
									<th style='min-width: 300px;'>شورتکد</th>
								</tr>
							</thead>
							
							<tbody>
								<tr>
									<td>نمایش آخرین قیمت طلای ۱۸ عیار</td>
									<td class='ltr'>[wp_gold key='gold_price']</td>
								</tr>
								<tr>
									<td>لیست قیمت سکه و طلا</td>
									<td class='ltr'>[wp_gold key='gold_list']</td>
								</tr>
								
								<tr>
									<td>نوع کالا</td>
									<td class='ltr'>[wp_gold key='product_type']</td>
								</tr>

								<tr>
									<td>وزن کالا</td>
									<td class='ltr'>[wp_gold key='product_weigth']</td>
								</tr>

								<tr>
									<td>اجرت وزنی</td>
									<td class='ltr'>[wp_gold key='weighted_wage']</td>
								</tr>

								<tr>
									<td>اجرت تعدادی</td>
									<td class='ltr'>[wp_gold key='number_wage']</td>
								</tr>

								<tr>
									<td>اجرت درصدی</td>
									<td class='ltr'>[wp_gold key='percentage_wage']</td>
								</tr>

								<tr>
									<td>سود</td>
									<td class='ltr'>[wp_gold key='interest']</td>
								</tr>

								<tr>
									<td>درصد مالیات بر ارزش افزوده</td>
									<td class='ltr'>[wp_gold key='tax_percentage']</td>
								</tr>

								<tr>
									<td>تخفیف</td>
									<td class='ltr'>[wp_gold key='discount']</td>
								</tr>

								<tr>
									<td>مجموع وزن سنگ ها</td>
									<td class='ltr'>[wp_gold key='stones_weight']</td>
								</tr>

								<tr>
									<td>مجموع تعداد سنگ ها</td>
									<td class='ltr'>[wp_gold key='stones_count']</td>
								</tr>

								<tr>
									<td>مجموع قیمت سنگ ها</td>
									<td class='ltr'>[wp_gold key='stones_price']</td>
								</tr>

								<tr>
									<td>مجموع قیمت چرم</td>
									<td class='ltr'>[wp_gold key='leather_price']</td>
								</tr>
								<tr>
									<td>مجموع قیمت نقره</td>
									<td class='ltr'>[wp_gold key='silver_price']</td>
								</tr>
								<tr>
									<td>عیار</td>
									<td class='ltr'>[wp_gold key='karat']</td>
								</tr>

								



							
								
							
							</tbody>
						</table>		
			"
		)
	);


	


	// register_setting($option_group, 'wra_send_factor', 'wra_rest_sanitize_checkbox');
	// add_settings_field(
	// 	'wra_send_factor',
	// 	'ارسال فاکتور به نرم افزار',
	// 	'wra_form_chkbox',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'name' => 'wra_send_factor'
	// 	)
	// );

	// add_settings_field(
	// 	'text38',
	// 	'',
	// 	'wra_form_html',
	// 	$page_slug,
	// 	'rest_section_id',
	// 	array(
	// 		'text' => 'فاکتورهای موفق در ووکامرس در نرم افزار حسابداری ایجاد شود یا خیر'
	// 	)
	// );

	if(isset($_GET['page']) && $_GET['page'] == 'rest_api_settings')
	{
		?>
		<script>
			////
			document.addEventListener('DOMContentLoaded', function () {
				const wra_gold_web_service = document.querySelector('select[name="wra_gold_web_service"]');
				wra_gold_web_service.addEventListener('change', function () {
					wra_load_webservice();
				});
			});
			
			function wra_load_webservice()
			{
				const wra_gold_web_service = document.querySelector('select[name="wra_gold_web_service"]');
				
				const wra_gold_web_service_username = document.querySelector('input[name="wra_gold_web_service_username"]');
				const wra_gold_web_service_password = document.querySelector('input[name="wra_gold_web_service_password"]');
				const wra_gold_web_service_token = document.querySelector('input[name="wra_gold_web_service_token"]');
						
					if(wra_gold_web_service.value == 'ratebox')
					{
						wra_gold_web_service_username.disabled = true; 
						wra_gold_web_service_password.disabled = true; 
						wra_gold_web_service_token.disabled = false; 
					}
					else
					{
						wra_gold_web_service_username.disabled = false; 
						wra_gold_web_service_password.disabled = false; 
						wra_gold_web_service_token.disabled = true; 
					}
			
			}
			setTimeout(function (){wra_load_webservice();},500);	





			document.addEventListener('DOMContentLoaded', function () {
				const wra_cron_job_status = document.querySelector('input[name="wra_cron_job_status"]');
				const wra_active_price = document.querySelectorAll('.wra_active_price input,.wra_active_price button,.wra_active_price select');
				const wra_deactive_price = document.querySelectorAll('.wra_deactive_price input');
				wra_cron_job_status.addEventListener('change', function () {
					wra_load_checkbox();
				});
			});
			
			function wra_load_checkbox()
			{
				const wra_cron_job_status = document.querySelector('input[name="wra_cron_job_status"]');
				const wra_active_price = document.querySelectorAll('.wra_active_price input,.wra_active_price button,.wra_active_price select');
				const wra_deactive_price = document.querySelectorAll('.wra_deactive_price input');

				wra_active_price.forEach(function(input) {
						input.disabled = !wra_cron_job_status.checked; 
					});

					wra_deactive_price.forEach(function(input) {
						input.disabled = wra_cron_job_status.checked; 
					});
				if(wra_cron_job_status.checked)
					wra_load_webservice();
			}
			setTimeout(function (){wra_load_checkbox();},500);	
			
			







		</script>
		<?php
	}




}






if (isset($_GET['wra_clear_database']))
{
	global $wpdb;
	$sql = "DELETE FROM `{$wpdb->base_prefix}wra_reports` WHERE 1";
	$wpdb->query($sql);

	$sql = "DELETE FROM `{$wpdb->base_prefix}wra_queue` WHERE status != 0";
	$wpdb->query($sql);
	
	wra_notice("گزارشات با موفقیت پاکسازی شد.", 'success');
}


if (isset($_GET['settings-updated']) && isset($_GET['page']) && $_GET['page'] == 'rest_api_settings') {
	wra_check_connection();
	wra_connect(1);

	wra_notice(" تنظیمات با موفقیت ذخیره شد.", 'success');
}

if (isset($_GET['check-connection'])) {
	wra_check_connection();
}





add_action('init', function() {
	if (isset($_GET['settings-updated']) && isset($_GET['page']) && $_GET['page'] == 'rest_api_settings') {
		if(isset($_GET['tab']) && $_GET['tab']=='gold')
		{
			wra_update_products_with_gold_price();
		}
	}



	if (isset($_GET['php-info']) && is_user_logged_in()) {
		phpinfo();
		die;
	}
});



