<?php




// افزودن تب طلا
add_filter('woocommerce_product_data_tabs', 'wra_add_custom_product_data_tab');
function wra_add_custom_product_data_tab($tabs) {
    $tabs['custom_tab'] = array(
        'label'    => __('ویژگی‌های طلا', 'wra_gold_fields'),
        'target'   => 'custom_product_data',
        'class'    => array('show_if_simple', 'show_if_variable'), 
        'priority' => 21, 
    );
    return $tabs;
}






// add_action( 'woocommerce_product_options_custom', 'add_custom_info_text_shipping_tab' );

// function add_custom_info_text_shipping_tab() {
//     echo '<div class="options_group">';
    
//     echo '<p class="form-field">';
//     echo '<label><strong>راهنما</strong></label>'; // ستون عنوان
//     echo '<span class="description">لطفاً قیمت محصول را با دقت وارد کنید. این قیمت در صفحه محصول نمایش داده می‌شود.</span>'; // ستون مقدار (متن سمت راست)
//     echo '</p>';

//     echo '</div>';
// }




// افزودن فیلدهای طب طلا
add_action('woocommerce_product_data_panels', 'wra_add_custom_product_data_fields');
function wra_add_custom_product_data_fields() {
    global $post;
    ?>
    <div id="custom_product_data" class="panel woocommerce_options_panel">
        <div class="options_group">
            <?php

            $gold_price = wra_gold_price();
            
            $wra_calculate_price_datails = wra_calculate_price_datails(get_the_ID(), $gold_price);


            echo '<hr><p class="wra-field-header">اطلاعات پایه</p>';

            // woocommerce_wp_checkbox(array(
            //     'id' => 'online_gold_price',
            //     'label' => __('محاسبه قیمت کالا بر اساس قیمت لحظه ای طلا', 'wra_gold_fields'),
            //     'class' => 'wra_checkbox',
            // ));


            $product_api_type=get_post_meta(get_the_ID(), 'product_api_type');
            if($product_api_type && is_array($product_api_type) && $product_api_type[0]==1)
            {
                $wra_post_source = 'api';
                $wra_is_editable = get_option('wra_is_editable');
            }    
            else
            {
                $wra_post_source = 'site';
                $wra_is_editable = 1;
            }   


            echo '
                <p class="form-field  ">
                    <label for="online_gold_price">محاسبه قیمت کالا بر اساس قیمت لحظه ای طلا</label>
                    <input type="checkbox" name="online_gold_price" id="online_gold_price" value="1" checked class="wra_checkbox" disabled>
                </p>
            ';




            // if(!$wra_is_editable)
            echo '<input type="hidden" name="online_gold_price" value="1">';




            woocommerce_wp_select(array(
                'id' => 'ProductType',
                'label' => __('نوع کالا', 'wra_gold_fields'),
                'class' => 'wra_select',
                'custom_attributes' => ['disabled' => 'disabled'],
                'options' => array(
                    '1' => __('طلای ساخته', 'wra_gold_fields'),  
                    '2' => __('سکه', 'wra_gold_fields'),  
                    '3' => __('سنگ', 'wra_gold_fields'),  
                    '4' => __('کالا', 'wra_gold_fields'),  
                    '5' => __('خدمات', 'wra_gold_fields'),  
                    '6' => __('جواهر', 'wra_gold_fields'),  
                ),
            ));

            woocommerce_wp_text_input(array(
                'id' => 'ProductUnit',
                'label' => __('عنوان واحد کالا', 'wra_gold_fields'),
                'custom_attributes' => !$wra_is_editable ?  [ 'readonly' => 'readonly'] :[],
            ));



            woocommerce_wp_text_input(array(
                'id' => 'ProductBarcode',
                'label' => __('بارکد کالا', 'wra_gold_fields'),
                'type'        => 'text',
                'custom_attributes' => !$wra_is_editable ? [ 'readonly' => 'readonly'] : [],
            ));


            // woocommerce_wp_checkbox(array(
            //     'id' => 'ProductIsInteger',
            //     'label' => __('محاسبات این کالا اعشاری است', 'wra_gold_fields'),
            //     'class' => 'wra_checkbox',
            //     'value' => 1,
            //     'custom_attributes' => !$wra_is_editable ? [ 'disabled' => 'disabled'] :[],
            // ));

            // if(!$wra_is_editable)
            //     echo '<input type="hidden" name="ProductIsInteger" value="'.get_post_meta(get_the_ID(), 'ProductIsInteger', true).'">';





            //     if($wra_is_editable)
            //     echo '
            //         <p class="form-field  ">
            //             <label for="ProductIsInteger">محاسبات این کالا اعشاری است</label>
            //             <input type="checkbox" name="ProductIsInteger" id="ProductIsInteger" value="1" '.(get_post_meta(get_the_ID(), 'ProductIsInteger', true)==1 ? 'checked' : '').' class="wra_checkbox">
            //         </p>
            //     ';
            // else
                // echo '
                //     <p class="form-field  ">
                //         <label for="ProductIsInteger">محاسبات این کالا اعشاری است</label>
                //         <input type="checkbox" name="ProductIsInteger" id="ProductIsInteger" value="1" '.(get_post_meta(get_the_ID(), 'ProductIsInteger', true)==1 ? 'checked' : '').' class="wra_checkbox" disabled>
                        
                //     </p>
                // ';
                echo '<input type="hidden" name="ProductIsInteger" value="1">';







            echo '<hr><p  class="wra-field-header">وزن و قیمت پایه</p>';

            woocommerce_wp_select(array(
                'id' => 'ProductPriceCalculationType',
                'label' => __('نوع روش محاسبه قیمت در فاکتور', 'wra_gold_fields'),
                'class' => 'wra_select',
                'custom_attributes' => ['disabled' => 'disabled'],
                'options' => array(
                    '1' => __('وزنی', 'wra_gold_fields'),
                    '2' => __('تعدادی', 'wra_gold_fields'),
                ),
            ));


            woocommerce_wp_text_input(array(
                'id' => '_weight',
                'label' => __('وزن مجموع', 'wra_gold_fields'),
                'type'        => 'text',
                'custom_attributes' => [ 'disabled' => 'disabled'],
            ));

            echo '
                <p class="form-field ProductCutie_field ">
                    <label for="RefWeight">وزن به عیار مرجع</label>
                    <input type="text" class="short" id="RefWeight" style="" value="'.($wra_calculate_price_datails['RefWeight']).'" readonly> 
                </p>
            ';

            woocommerce_wp_text_input(array(
                'id' => 'ProductRefCurrentAmount_Gold',
                'label' => __('موجودی وزنی کالا به عیار مرجع (750)', 'wra_gold_fields'),
                'type'        => 'number',
                'custom_attributes' => !$wra_is_editable ? [ 'readonly' => 'readonly'] : [
                    'step' => '0.001',       
                    'min'  => '0',          
                    'max'  => '1000000000000',  
                    'required'     => '',
                ],
            ));



            woocommerce_wp_text_input(array(
                'id' => 'ProductCutie',
                'label' => __('عیار', 'wra_gold_fields'),
                'type'        => 'number',
                'custom_attributes' => !$wra_is_editable ? [ 'readonly' => 'readonly'] : [
                    'step' => '1',       
                    'min'  => '0',          
                    'max'  => '999',  
                    'required'     => '',
                ],

            ));


            echo '
                <p class="form-field ProductCutie_field ">
                    <label for="gold_price">فی عیار 750 ('.get_woocommerce_currency_symbol().')</label>
                    <input type="text" class="short" id="gold_price" style="" value="'.number_format(wra_gold_price()).'" readonly> 
                </p>
            ';

            echo '
                <p class="form-field ProductCutie_field ">
                    <label for="NewPrice">قیمت بر اساس عیار طلا ('.get_woocommerce_currency_symbol().')</label>
                    <input type="text" class="short" id="NewPrice" style="" value="'.number_format($wra_calculate_price_datails['NewPrice']).'" readonly> 
                </p>
            ';




            echo '
                <p class="form-field ProductCutie_field ">
                    <label for="RefUnitPrice">مبلغ واحد به عیار مرجع ('.get_woocommerce_currency_symbol().')</label>
                    <input type="text" class="short" id="RefUnitPrice" style="" value="'.number_format($wra_calculate_price_datails['RefUnitPrice']).'" readonly> 
                </p>
            ';


            echo '<hr><p class="wra-field-header">اجرت</p>';

            woocommerce_wp_select(array(
                'id' => 'ProductSaleFeeType',
                'label' => __('نوع اجرت در فروش', 'wra_gold_fields'),
                'class' => 'wra_select',
                'custom_attributes' => !$wra_is_editable ? ['disabled' => 'disabled'] : [],
                'options' => array(
                    '1' => __('وزنی', 'wra_gold_fields'),
                    '2' => __('تعدادی', 'wra_gold_fields'),
                ),
            ));



            woocommerce_wp_text_input(array(
                'id' => 'ProductSaleFeeValue',
                'label' => __('مقدار اجرت در فروش ('.get_woocommerce_currency_symbol().')', 'wra_gold_fields'),
                'type'        => 'number',
                'custom_attributes' => !$wra_is_editable ? [ 'readonly' => 'readonly'] :[
                    'step' => '1',       
                    'min'  => '0',          
                    'max'  => '1000000000000', 
                ],

            ));


            woocommerce_wp_text_input(array(
                'id' => 'ProductSaleFeePercent',
                'label' => __('مقدار اجرت درصدی در فروش (%)', 'wra_gold_fields'),
                'type'        => 'number',
                'custom_attributes' => !$wra_is_editable ? [ 'readonly' => 'readonly'] :[
                    'step' => '0.01',       
                    'min'  => '0',          
                    'max'  => '100',  
                    ],
            ));

            echo '
                <p class="form-field ProductCutie_field ">
                    <label for="PercentWageRefWeight">گرم اجرت درصدی </label>
                    <input type="text" class="short" id="PercentWageRefWeight" style="" value="'.$wra_calculate_price_datails['PercentWageRefWeight'].' گرم" readonly> 
                </p>
            ';

            echo '
                <p class="form-field ProductCutie_field ">
                    <label for="PercentWageMoney">ریال اجرت درصدی  ('.get_woocommerce_currency_symbol().')</label>
                    <input type="text" class="short" id="PercentWageMoney" style="" value="'.number_format($wra_calculate_price_datails['PercentWageMoney']).'" readonly> 
                </p>
            ';



            echo '<hr><p class="wra-field-header">سود</p>';

            woocommerce_wp_select(array(
                'id' => 'ProductProfitKind',
                'label' => __('نوع سود', 'wra_gold_fields'),
                'class' => 'wra_select',
                'custom_attributes' => !$wra_is_editable ? ['disabled' => 'disabled'] :[],
                'options' => array(
                    '0' => __('درصدی', 'wra_gold_fields'),
                    '1' => __('ریالی', 'wra_gold_fields'),
                ),
            ));



            woocommerce_wp_text_input(array(
                'id' => 'ProductProfitValue',
                'label' => __('مقدار سود', 'wra_gold_fields'),
                'type'        => 'number',
                'custom_attributes' => !$wra_is_editable ? [ 'readonly' => 'readonly'] : [
     
                    'min'  => '0',          
                    'max'  => '1000000000000',  
                ],
            ));

            
            echo '
                <p class="form-field ProductCutie_field ">
                    <label for="ProfitPercent"> درصد سود (%)</label>
                    <input type="text" class="short" id="ProfitPercent" style="" value="'.( get_post_meta(get_the_ID(), 'ProductProfitKind', true)==1 ? number_format($wra_calculate_price_datails['ProfitPercent']) : get_post_meta(get_the_ID(), 'ProductProfitValue', true)).'" readonly> 
                </p>
            ';



            echo '
                <p class="form-field ProductCutie_field ">
                    <label for="ProfitMoney"> مبلغ سود ('.get_woocommerce_currency_symbol().') </label>
                    <input type="text" class="short" id="ProfitMoney" style="" value="'.( get_post_meta(get_the_ID(), 'ProductProfitKind', true)==0 ? number_format($wra_calculate_price_datails['ProfitMoney']) : get_post_meta(get_the_ID(), 'ProductProfitValue', true)).'" readonly> 
                </p>
            ';





            // woocommerce_wp_checkbox(array(
            //     'id' => 'ProductExemptOnSale',
            //     'label' => __('معاف از مالیات در فروش', 'wra_gold_fields'),
            //     'class' => 'wra_checkbox',
            //     'custom_attributes' => !$wra_is_editable ? [ 'disabled' => 'disabled'] :[],
            // ));

            echo '<hr><p class="wra-field-header">مالیات</p>';



            if($wra_is_editable)
                echo '
                    <p class="form-field ProductExemptOnSale_field ">
                        <label for="ProductExemptOnSale">معاف از مالیات در فروش</label>
                        <input type="checkbox" name="ProductExemptOnSale" id="ProductExemptOnSale" value="1" '.(get_post_meta(get_the_ID(), 'ProductExemptOnSale', true)==1 ? 'checked' : '').' class="wra_checkbox">
                    </p>
                ';
            else
                echo '
                    <p class="form-field ProductExemptOnSale_field ">
                        <label for="ProductExemptOnSale">معاف از مالیات در فروش</label>
                        <input type="checkbox" name="ProductExemptOnSale" id="ProductExemptOnSale" value="1" '.(get_post_meta(get_the_ID(), 'ProductExemptOnSale', true)==1 ? 'checked' : '').' class="wra_checkbox" disabled>
                        <input type="hidden" name="ProductExemptOnSale" value="'.get_post_meta(get_the_ID(), 'ProductExemptOnSale', true).'">
                        <span style="padding: 0px 10px;"> ('.number_format($wra_calculate_price_datails['TaxMoney']).' '.get_woocommerce_currency_symbol()  . ')</span>
                    </p>
                ';
           
                woocommerce_wp_text_input(array(
                    'id' => 'ProductTax',
                    'label' => __('مالیات (%)', 'wra_gold_fields'),
                    'type'        => 'number',
                    'custom_attributes' => !$wra_is_editable ? [ 'readonly' => 'readonly'] :[
                        'step' => '0.01',         
                        'min'  => '0',          
                        'max'  => '100',  
                        ],
                ));


                woocommerce_wp_select(array(
                    'id' => 'ProductCalcTaxTollType',
                    'label' => __('نحوه محاسبه مالیات بر ارزش افزوده ', 'wra_gold_fields'),
                    'class' => 'wra_select',
                    'custom_attributes' => !$wra_is_editable ? ['disabled' => 'disabled'] :[],
                    'options' => array(
                        '1' => __('اجرت و سود', 'wra_gold_fields'),
                        '2' => __('قیمت کل', 'wra_gold_fields'),
                    ),
                ));
    


                echo '
                    <p class="form-field ProductCutie_field ">
                        <label for="TaxMoney"> مبلغ مالیات ('.get_woocommerce_currency_symbol().') </label>
                        <input type="text" class="short" id="TaxMoney" style="" value="'.number_format($wra_calculate_price_datails['TaxMoney']).'" readonly> 
                    </p>
                ';


    



                echo '<hr><p class="wra-field-header">متعلقات</p>';

    
    
                woocommerce_wp_text_input(array(
                    'id' => 'ProductRockWeight',
                    'label' => __('وزن سنگ ها', 'wra_gold_fields'),
                    'type'        => 'number',
                    'custom_attributes' => !$wra_is_editable ? [ 'readonly' => 'readonly'] :[
                        'step' => '0.001',       
                        'min'  => '0',          
                        'max'  => '1000000000000',  
                        ],
                ));
    
                woocommerce_wp_text_input(array(
                    'id' => 'ProductRockCount',
                    'label' => __('تعداد سنگ ها', 'wra_gold_fields'),
                    'type'        => 'number',
                    'custom_attributes' => !$wra_is_editable ? [ 'readonly' => 'readonly'] :[
                        'step' => '1',       
                        'min'  => '0',          
                        'max'  => '1000000000000', 
                        ],
                ));
    
                woocommerce_wp_text_input(array(
                    'id' => 'ProductRockRialCost',
                    'label' => __('ارزش ریالی سنگ ها ('.get_woocommerce_currency_symbol().')', 'wra_gold_fields'),
                    'type'        => 'number',
                    'custom_attributes' => !$wra_is_editable ? [ 'readonly' => 'readonly'] :[
                        'step' => '1',       
                        'min'  => '0',          
                        'max'  => '1000000000000',
                        ],
                ));


                woocommerce_wp_text_input(array(
                    'id' => 'ProductLeatherRialCost',
                    'label' => __('ارزش ریالی چرم ('.get_woocommerce_currency_symbol().')', 'wra_gold_fields'),
                    'type'        => 'number',
                    'custom_attributes' => !$wra_is_editable ? [ 'readonly' => 'readonly'] :[
                        'step' => '1',       
                        'min'  => '0',          
                        'max'  => '1000000000000', 
                    ],
                ));
    
                woocommerce_wp_text_input(array(
                    'id' => 'ProductSilverRialCost',
                    'label' => __('ارزش ریالی نقره ('.get_woocommerce_currency_symbol().')', 'wra_gold_fields'),
                    'type'        => 'number',
                    'custom_attributes' => !$wra_is_editable ? [ 'readonly' => 'readonly'] :[
                        'step' => '1',       
                        'min'  => '0',          
                        'max'  => '1000000000000',  
                    ],
                ));  
    
    










            // woocommerce_wp_text_input(array(
            //     'id' => 'ProductToll',
            //     'label' => __('عوارض (%)', 'wra_gold_fields'),
            //     'type'        => 'number',
            //     'custom_attributes' => !$wra_is_editable ? [ 'readonly' => 'readonly'] :[
            //         'step' => '1',       
            //         'min'  => '0',          
            //         'max'  => '100',  
            //         ],
            // ));



            echo '<hr><p class="wra-field-header">تخفیف</p>';


            woocommerce_wp_select(array(
                'id' => 'DiscountType',
                'label' => __('نوع تخفیف', 'wra_gold_fields'),
                'class' => 'wra_select',
                'options' => array(
                    '0' => __('درصد', 'wra_gold_fields'),
                    '1' => __('ریالی', 'wra_gold_fields'),
                ),
            ));

    


            woocommerce_wp_text_input(array(
                'id' => 'DiscountMoney',
                'label' => __('مقدار تخفیف', 'wra_gold_fields'),
                'type'        => 'number',
                'custom_attributes' => [   
                    'step' => '0.01',  
                    'min'  => '0',          
                    // 'max'  => '100',  
                ],
                // 'desc_tip'    => true, // برای نمایش راهنما به‌صورت tooltip
                // 'description' => 'این فیلد برای انتخاب گزینه‌ای خاص است.',
            ));









            echo '<hr><p class="wra-field-header">مبلغ طلا</p>';
 


            echo '
                <p class="form-field ProductCutie_field ">
                    <label for="PurePrice"> مبلغ خالص ('.get_woocommerce_currency_symbol().') </label>
                    <input type="text" class="short" id="PurePrice" style="" value="'.(number_format($wra_calculate_price_datails['PurePrice'])).'" readonly> 
                </p>
            ';
            echo '
                <p class="form-field ProductCutie_field ">
                    <label for="Addition"> مبلغ اضافات ('.get_woocommerce_currency_symbol().') </label>
                    <input type="text" class="short" id="Addition" style="" value="'.(number_format($wra_calculate_price_datails['Addition'])).'" readonly> 
                </p>
            ';
            echo '
                <p class="form-field ProductCutie_field ">
                    <label for="GoldPrice_Wage_Profit"> مبلغ خالص به علاوه سود ('.get_woocommerce_currency_symbol().') </label>
                    <input type="text" class="short" id="GoldPrice_Wage_Profit" style="" value="'.(number_format($wra_calculate_price_datails['GoldPrice_Wage_Profit'])).'" readonly> 
                </p>
            ';
            echo '
                <p class="form-field ProductCutie_field ">
                    <label for="DiscountMoney"> مبلغ تخفیف ('.get_woocommerce_currency_symbol().') </label>
                    <span style="display:flex">
                        <input type="text" class="short" id="DiscountMoney" style="width: 33%;" value="'.(number_format($wra_calculate_price_datails['DiscountMoney'])).'" readonly> 
                        <input type="text" class="short" id="DiscountPercent" style="width: 21.5%;" value="'.($wra_calculate_price_datails['DiscountPercent'].'%').'" readonly> 
                    </span>
                </p>
            ';



            echo '
                <p class="form-field ProductCutie_field ">
                    <label for="TotalPrice"> مبلغ نهایی ('.get_woocommerce_currency_symbol().') </label>
                    <input type="text" class="short" id="TotalPrice" style="" value="'.(number_format($wra_calculate_price_datails['TotalPrice'])).'" readonly> 
                </p>
            ';












            // چک‌باکس
            // woocommerce_wp_checkbox(array(
            //     'id' => '_custom_checkbox',
            //     'label' => __('فعال‌سازی گزینه', 'wra_gold_fields'),
            // ));

   
            ?>
        </div>
    </div>
    <script>
        wraSetMaxValue();
        document.getElementById('DiscountType').addEventListener('change', function () {
            wraSetMaxValue();
        });
        document.getElementById('ProductProfitKind').addEventListener('change', function () {
            wraSetMaxValue();
        });

        function wraSetMaxValue()
        {
            var selectedValue = document.getElementById('DiscountType').value;
            var inputField = document.getElementById('DiscountMoney');

            if (selectedValue == 1) {
            inputField.max = 10000000000;
             inputField.step = 1;
            } else {
                inputField.max = 100; 
                inputField.step = 0.01;
            }


            var selectedValue = document.getElementById('ProductProfitKind').value;
            var inputField = document.getElementById('ProductProfitValue');

            if (selectedValue == 1) {
            inputField.max = 10000000000;
             inputField.step = 1;
            } else {
                inputField.max = 100; 
                inputField.step = 0.01;
            }
            
        }
    </script>

    <script>
        const form = document.querySelector('#post');
        const inputs = form.querySelectorAll('input');

        inputs.forEach(input => {
        const errorMessage = input.nextElementSibling; // انتخاب span.error مرتبط

        // بررسی رویداد invalid برای هر ورودی
        input.addEventListener('invalid', function (event) {
            const value = event.target.value;
            const min = event.target.hasAttribute('min') ? parseFloat(event.target.min) : null;
            const max = event.target.hasAttribute('max') ? parseFloat(event.target.max) : null;
            const step = event.target.hasAttribute('step') ? parseFloat(event.target.step) : null;
            const required = event.target.hasAttribute('required');
            const minlength = event.target.hasAttribute('minlength') ? parseInt(event.target.minlength) : null;
            const type = event.target.type;

            // تنظیم پیام خطا بر اساس نوع خطا
            if (required && !value) {
            event.target.setCustomValidity('لطفاً این فیلد را پر کنید');
            errorMessage.textContent = 'لطفاً این فیلد را پر کنید';
            } else if (type === 'number' && value && min !== null && value < min) {
            event.target.setCustomValidity(`عدد باید حداقل ${min} باشد`);
            errorMessage.textContent = `عدد باید حداقل ${min} باشد`;
            } else if (type === 'number' && value && max !== null && value > max) {
            event.target.setCustomValidity(`عدد باید حداکثر ${max} باشد`);
            errorMessage.textContent = `عدد باید حداکثر ${max} باشد`;
            } else if (type === 'number' && value && step !== null && min !== null && (value - min) % step !== 0) {
            event.target.setCustomValidity(`عدد باید مضرب ${step} باشد`);
            errorMessage.textContent = `عدد باید مضرب ${step} باشد`;
            } else if (type === 'text' && minlength !== null && value.length < minlength) {
            event.target.setCustomValidity(`حداقل ${minlength} کاراکتر وارد کنید`);
            errorMessage.textContent = `حداقل ${minlength} کاراکتر وارد کنید`;
            } else {
            event.target.setCustomValidity('');
            errorMessage.textContent = '';
            }
        });

        // پاک کردن پیام خطا هنگام تغییر ورودی
        input.addEventListener('input', function (event) {
            event.target.setCustomValidity('');
            errorMessage.textContent = '';
        });
        });

        // جلوگیری از ارسال فرم اگر خطایی وجود دارد
        form.addEventListener('submit', function (event) {
        let isValid = true;
        inputs.forEach(input => {
            if (!input.checkValidity()) {
            isValid = false;
            input.dispatchEvent(new Event('invalid')); // فعال کردن رویداد invalid
            }
        });
        if (!isValid) {
            event.preventDefault(); // جلوگیری از ارسال فرم
        }
        });
    </script>
    <?php
} 


// ذخیره فیلدهای طلا
add_action('woocommerce_process_product_meta', 'wra_save_custom_product_data_fields');
function wra_save_custom_product_data_fields($post_id) {



    
    update_post_meta($post_id, 'online_gold_price', isset($_POST['online_gold_price']) ? 1 : 0);

    if (isset($_POST['ProductType']))
        update_post_meta($post_id, 'ProductType', sanitize_text_field($_POST['ProductType']));
        
    if (isset($_POST['ProductUnit']))
        update_post_meta($post_id, 'ProductUnit', sanitize_text_field($_POST['ProductUnit']));
        
    if (isset($_POST['ProductBarcode']))
        update_post_meta($post_id, 'ProductBarcode', sanitize_text_field($_POST['ProductBarcode']));
        
        update_post_meta($post_id, 'ProductIsInteger', isset($_POST['ProductIsInteger']) ? 1 : 0);

    if (isset($_POST['ProductPriceCalculationType']))
        update_post_meta($post_id, 'ProductPriceCalculationType', sanitize_text_field($_POST['ProductPriceCalculationType']));
        
        if (isset($_POST['ProductRefCurrentAmount_Gold']))
        update_post_meta($post_id, 'ProductRefCurrentAmount_Gold', sanitize_text_field($_POST['ProductRefCurrentAmount_Gold']));

    if (isset($_POST['ProductCutie']))
        update_post_meta($post_id, 'ProductCutie', sanitize_text_field($_POST['ProductCutie']));
    
    if (isset($_POST['ProductSaleFeeType']))
        update_post_meta($post_id, 'ProductSaleFeeType', sanitize_text_field($_POST['ProductSaleFeeType']));
        
    if (isset($_POST['ProductSaleFeeValue']))
        update_post_meta($post_id, 'ProductSaleFeeValue', sanitize_text_field($_POST['ProductSaleFeeValue']));
        
    if (isset($_POST['ProductSaleFeePercent']))
        update_post_meta($post_id, 'ProductSaleFeePercent', sanitize_text_field($_POST['ProductSaleFeePercent']));
        

    if (isset($_POST['ProductProfitKind']))
        update_post_meta($post_id, 'ProductProfitKind', sanitize_text_field($_POST['ProductProfitKind']));
        



    if (isset($_POST['ProductProfitValue']))
        update_post_meta($post_id, 'ProductProfitValue', sanitize_text_field($_POST['ProductProfitValue']));
        


        update_post_meta($post_id, 'ProductExemptOnSale', isset($_POST['ProductExemptOnSale']) ? 1 : 0);


        // if (isset($_POST['ProductExemptOnSale']))
        // update_post_meta($post_id, 'ProductExemptOnSale', sanitize_text_field($_POST['ProductExemptOnSale']));
        

        // update_post_meta($post_id, 'ProductExemptOnSale', isset($_POST['ProductExemptOnSale']) ? 1 : 0);

        if (isset($_POST['ProductTax']))
        update_post_meta($post_id, 'ProductTax', sanitize_text_field($_POST['ProductTax']));
        
        if (isset($_POST['ProductCalcTaxTollType']))
        update_post_meta($post_id, 'ProductCalcTaxTollType', sanitize_text_field($_POST['ProductCalcTaxTollType']));
        

    if (isset($_POST['ProductRockWeight']))
        update_post_meta($post_id, 'ProductRockWeight', sanitize_text_field($_POST['ProductRockWeight']));
        
    if (isset($_POST['ProductRockCount']))
        update_post_meta($post_id, 'ProductRockCount', sanitize_text_field($_POST['ProductRockCount']));
        


    if (isset($_POST['ProductRockRialCost']))
        update_post_meta($post_id, 'ProductRockRialCost', sanitize_text_field($_POST['ProductRockRialCost']));
        
        
        if (isset($_POST['ProductLeatherRialCost']))
        update_post_meta($post_id, 'ProductLeatherRialCost', sanitize_text_field($_POST['ProductLeatherRialCost']));

        
    if (isset($_POST['ProductSilverRialCost']))
        update_post_meta($post_id, 'ProductSilverRialCost', sanitize_text_field($_POST['ProductSilverRialCost']));



        if (isset($_POST['DiscountType']))
        update_post_meta($post_id, 'DiscountType', sanitize_text_field($_POST['DiscountType']));

        if (isset($_POST['DiscountMoney']))
        update_post_meta($post_id, 'DiscountMoney', sanitize_text_field($_POST['DiscountMoney']));


       

}

/////////////////////////////////////////////////////////////////
// افزودن شورت کد
// [wp_gold key="product_weigth"]


add_shortcode('wp_gold', 'custom_wp_gold_shortcode');
function custom_wp_gold_shortcode($atts) {
    global $product;

    // گرفتن مقدار key از ویژگی‌های شورت‌کد
    $atts = shortcode_atts([
        'key' => ''
    ], $atts);

    $key = sanitize_text_field($atts['key']);



    // فقط در صفحه محصول کار کند
    if ((!is_product() || !$product instanceof WC_Product) && !in_array($key, ['gold_price','gold_list']) ) {
        return '';
    }


    if (!$key && !in_array($key, ['gold_price','gold_list'])) return '';

    if($product)
        $value = get_post_meta($product->get_id(), $key, true);
    else
        $value='';

    // اگر خالی بود، چیزی نشون نده
    if ($value === '' && !in_array($key, ['gold_price','gold_list'])) return '';

    $result = '<div class="product_meta"><span class="posted_in ">';

    switch($key)
    {
        case 'product_type': $result .= '<span class="meta-label">نوع کالا</span>: ' . esc_html($value); break;
        case 'product_weigth': $result .= '<span class="meta-label">وزن کالا</span>: ' . esc_html($value); break;
        case 'weighted_wage': $result .= '<span class="meta-label">اجرت وزنی</span>: ' . esc_html($value) . ' ' . get_woocommerce_currency_symbol(); break;
        case 'number_wage': $result.= '<span class="meta-label">اجرت تعدادی</span>: ' . esc_html($value) . ' ' . get_woocommerce_currency_symbol(); break;
        case 'percentage_wage': $result .= '<span class="meta-label">اجرت درصدی</span>: ' . esc_html($value); break;
        case 'interest': $result .= '<span class="meta-label">سود</span>: ' . esc_html($value) . ' ' . get_woocommerce_currency_symbol(); break;
        case 'tax_percentage': $result .= '<span class="meta-label">درصد مالیات بر ارزش افزوده</span>: ' . esc_html($value); break;
        case 'discount': $result .= '<span class="meta-label">تخفیف</span>: ' . esc_html($value) . ' ' . get_woocommerce_currency_symbol(); break;
        case 'stones_weight': $result .= '<span class="meta-label">مجموع وزن سنگ ها</span>: ' . esc_html($value); break;
        case 'stones_count': $result .= '<span class="meta-label">مجموع تعداد سنگ ها</span>: ' . esc_html($value); break;
        case 'stones_price': $result .= '<span class="meta-label">مجموع قیمت سنگ ها</span>: ' . esc_html($value) . ' ' . get_woocommerce_currency_symbol(); break;
        case 'leather_price': $result .= '<span class="meta-label">مجموع قیمت چرم</span>: ' . esc_html($value) . ' ' . get_woocommerce_currency_symbol(); break;
        case 'silver_price': $result .= '<span class="meta-label">مجموع قیمت نقره</span>: ' . esc_html($value . ' ' . get_woocommerce_currency_symbol()); break;
        case 'karat': $result .= '<span class="meta-label">عیار</span>: ' . esc_html($value); break;
        case 'gold_price': $result .= '<span class="meta-label">آخرین قیمت طلای 18 عیار</span>: 0 '. get_woocommerce_currency_symbol(); break;
        case 'gold_list': $result .= gold_list_shortcode();break;
    }
    $result .= '</span></div>';


  

    return $result;
}




////////////////////////////////////////////////////////////////
// آپدیت قیمت کالا در زمان ذخیره

// add_action('save_post_product', 'wra_update_price', 200, 3);
// add_action('woocommerce_admin_process_product_object', 'wra_update_price', 20, 1);
add_action('woocommerce_after_product_object_save', 'wra_update_price', 20, 1);
function wra_update_price($product) {
    // فقط برای ذخیره واقعی
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    wra_update_products_with_gold_price($product->get_id());

}


